/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.e4.tools.emf.ui.common.IModelElementProvider;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class FindImportElementDialog
extends TitleAreaDialog {
    private EObject element;
    private AbstractComponentEditor editor;
    private TableViewer viewer;
    private Messages Messages;

    public FindImportElementDialog(Shell parentShell, AbstractComponentEditor editor, EObject element, Messages Messages2) {
        super(parentShell);
        this.element = element;
        this.editor = editor;
        this.Messages = Messages2;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        final Image titleImage = new Image((Device)parent.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/import_wiz.png"));
        this.setTitleImage(titleImage);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                titleImage.dispose();
            }
        });
        this.getShell().setText(this.Messages.FindImportElementDialog_ShellTitle);
        this.setTitle(this.Messages.FindImportElementDialog_Title);
        this.setMessage(this.Messages.FindImportElementDialog_Message);
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.Messages.FindImportElementDialog_Search);
        final Text searchText = new Text(container, 2688);
        GridData gd = new GridData(768);
        searchText.setLayoutData((Object)gd);
        l = new Label(container, 8);
        this.viewer = new TableViewer(container);
        gd = new GridData(1808);
        gd.heightHint = 200;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                EObject o = (EObject)cell.getElement();
                cell.setImage(FindImportElementDialog.this.editor.getImage(o, searchText.getDisplay()));
                MApplicationElement appEl = (MApplicationElement)o;
                StyledString styledString = new StyledString(String.valueOf(FindImportElementDialog.this.editor.getLabel(o)) + " (" + (appEl.getElementId() == null ? "<" + ((FindImportElementDialog)FindImportElementDialog.this).Messages.FindImportElementDialog_noId + ">" : appEl.getElementId()) + ")", null);
                String detailLabel = FindImportElementDialog.this.editor.getDetailLabel(o);
                if (detailLabel != null && !detailLabel.equals(appEl.getElementId())) {
                    styledString.append(" - " + detailLabel, StyledString.DECORATIONS_STYLER);
                }
                styledString.append(" - " + o.eResource().getURI(), StyledString.COUNTER_STYLER);
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setText(styledString.getString());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FindImportElementDialog.this.okPressed();
            }
        });
        final WritableList list = new WritableList();
        this.viewer.setInput((Object)list);
        final ClassContributionCollector collector = this.getCollector();
        searchText.addModifyListener(new ModifyListener(){
            private ModelResultHandlerImpl currentResultHandler;

            public void modifyText(ModifyEvent e) {
                if (this.currentResultHandler != null) {
                    this.currentResultHandler.cancled = true;
                }
                list.clear();
                IModelElementProvider.Filter filter = new IModelElementProvider.Filter(FindImportElementDialog.this.element.eClass(), searchText.getText());
                this.currentResultHandler = new ModelResultHandlerImpl((IObservableList)list, filter, FindImportElementDialog.this.editor, FindImportElementDialog.this.element.eResource());
                collector.findModelElements(filter, this.currentResultHandler);
            }
        });
        Button button = new Button(container, 8);
        button.setText(this.Messages.FindImportElementDialog_ClearCache);
        button.setLayoutData((Object)new GridData(3, 2, true, false, 2, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                collector.clearModelCache();
            }
        });
        return comp;
    }

    protected void okPressed() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty()) {
            MApplicationElement el = (MApplicationElement)s.getFirstElement();
            if (el.getElementId() != null && el.getElementId().trim().length() > 0) {
                Command cmd = SetCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)this.element, (Object)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID, (Object)el.getElementId());
                if (cmd.canExecute()) {
                    this.editor.getEditingDomain().getCommandStack().execute(cmd);
                    super.okPressed();
                }
            } else {
                this.setErrorMessage(this.Messages.FindImportElementDialog_NoIdReference);
            }
        }
    }

    private ClassContributionCollector getCollector() {
        Bundle bundle = FrameworkUtil.getBundle(FindImportElementDialog.class);
        BundleContext context = bundle.getBundleContext();
        ServiceReference ref = context.getServiceReference(ClassContributionCollector.class.getName());
        if (ref != null) {
            return (ClassContributionCollector)context.getService(ref);
        }
        return null;
    }

    private static class ModelResultHandlerImpl
    implements IModelElementProvider.ModelResultHandler {
        private boolean cancled = false;
        private IObservableList list;
        private IModelElementProvider.Filter filter;
        private AbstractComponentEditor editor;
        private Resource resource;

        public ModelResultHandlerImpl(IObservableList list, IModelElementProvider.Filter filter, AbstractComponentEditor editor, Resource resource) {
            this.list = list;
            this.filter = filter;
            this.editor = editor;
            this.resource = resource;
        }

        public void result(EObject data) {
            if (!this.cancled && !this.resource.getURI().equals((Object)data.eResource().getURI()) && data instanceof MApplicationElement) {
                String elementId = ((MApplicationElement)data).getElementId();
                if (elementId == null) {
                    this.list.add((Object)data);
                    return;
                }
                if (elementId != null && elementId.trim().length() > 0 && this.filter.elementIdPattern.matcher(elementId).matches()) {
                    this.list.add((Object)data);
                    return;
                }
                String label = this.editor.getDetailLabel(data);
                if (elementId != null && label != null && label.trim().length() > 0 && this.filter.elementIdPattern.matcher(label).matches()) {
                    this.list.add((Object)data);
                }
            }
        }
    }
}

