/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerKeyBindingTest
extends ModelReconcilerTest {
    private void testKeySequence_KeySequence(String before, String after) {
        MApplication application = this.createApplication();
        MBindingTable bindingTable = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        application.getBindingTables().add(bindingTable);
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MKeyBinding keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        keyBinding.setKeySequence(before);
        keyBinding.setCommand(command);
        bindingTable.getBindings().add(keyBinding);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        keyBinding.setKeySequence(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        bindingTable = (MBindingTable)application.getBindingTables().get(0);
        command = (MCommand)application.getCommands().get(0);
        keyBinding = (MKeyBinding)bindingTable.getBindings().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerKeyBindingTest.assertEquals((String)before, (String)keyBinding.getKeySequence());
        this.applyAll(deltas);
        ModelReconcilerKeyBindingTest.assertEquals((String)after, (String)keyBinding.getKeySequence());
    }

    public void testKeySequence_KeySequence_NullNull() {
        this.testKeySequence_KeySequence(null, null);
    }

    public void testKeySequence_KeySequence_NullEmpty() {
        this.testKeySequence_KeySequence(null, "");
    }

    public void testKeySequence_KeySequence_NullString() {
        this.testKeySequence_KeySequence(null, "Ctrl+S");
    }

    public void testKeySequence_KeySequence_EmptyNull() {
        this.testKeySequence_KeySequence("", null);
    }

    public void testKeySequence_KeySequence_EmptyEmpty() {
        this.testKeySequence_KeySequence("", "");
    }

    public void testKeySequence_KeySequence_EmptyString() {
        this.testKeySequence_KeySequence("", "Ctrl+S");
    }

    public void testKeySequence_KeySequence_StringNull() {
        this.testKeySequence_KeySequence("Ctrl+S", null);
    }

    public void testKeySequence_KeySequence_StringEmpty() {
        this.testKeySequence_KeySequence("Ctrl+S", "");
    }

    public void testKeySequence_KeySequence_StringStringUnchanged() {
        this.testKeySequence_KeySequence("Ctrl+S", "Ctrl+S");
    }

    public void testKeySequence_KeySequence_StringStringChanged() {
        this.testKeySequence_KeySequence("Ctrl+S", "Ctrl+D");
    }
}

