/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerMenuItemTest
extends ModelReconcilerTest {
    private void testMenuItem_Mnemonics(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menu.getChildren().add(menuItem);
        menuItem.setMnemonics(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menuItem.setMnemonics(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        menuItem = (MMenuItem)menu.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerMenuItemTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerMenuItemTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerMenuItemTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerMenuItemTest.assertEquals((int)1, (int)menu.getChildren().size());
        ModelReconcilerMenuItemTest.assertEquals((Object)menuItem, menu.getChildren().get(0));
        ModelReconcilerMenuItemTest.assertEquals((String)before, (String)menuItem.getMnemonics());
        this.applyAll(deltas);
        ModelReconcilerMenuItemTest.assertEquals((String)after, (String)menuItem.getMnemonics());
    }

    public void testMenuItem_Mnemonics_NullNull() {
        this.testMenuItem_Mnemonics(null, null);
    }

    public void testMenuItem_Mnemonics_NullEmpty() {
        this.testMenuItem_Mnemonics(null, "");
    }

    public void testMenuItem_Mnemonics_NullString() {
        this.testMenuItem_Mnemonics(null, "m");
    }

    public void testMenuItem_Mnemonics_EmptyNull() {
        this.testMenuItem_Mnemonics("", null);
    }

    public void testMenuItem_Mnemonics_EmptyEmpty() {
        this.testMenuItem_Mnemonics("", "");
    }

    public void testMenuItem_Mnemonics_EmptyString() {
        this.testMenuItem_Mnemonics("", "m");
    }

    public void testMenuItem_Mnemonics_StringNull() {
        this.testMenuItem_Mnemonics("m", null);
    }

    public void testMenuItem_Mnemonics_StringEmpty() {
        this.testMenuItem_Mnemonics("m", "");
    }

    public void testMenuItem_Mnemonics_StringStringUnchanged() {
        this.testMenuItem_Mnemonics("m", "m");
    }

    public void testMenuItem_Mnemonics_StringStringChanged() {
        this.testMenuItem_Mnemonics("m", "n");
    }
}

