/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.clrfactory;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.e4.xwt.ICLRFactory;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.clrfactory.CLR;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactory;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactoryDefault;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactoryNamespace;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactoryOption;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactoryOptionArgs;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactorySingleton;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFactoryValue;
import org.eclipse.e4.xwt.tests.clrfactory.CLRFadeFactory;
import org.eclipse.swt.widgets.Button;

public class CLRFactoryTests
extends XWTTestCase {
    public void testCLRFactoryDefault() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryDefault.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.assertTrue((boolean)element.getText().equals(""));
            }
        });
    }

    public void testCLRFactoryValue() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryValue.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.assertTrue((boolean)element.getText().equals("arg1 arg2"));
            }
        });
    }

    public void testCLRFactoryNamespace() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryNamespace.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.assertTrue((boolean)element.getText().equals(""));
            }
        });
    }

    public void testCLRFactorySingleton() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactorySingleton.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                Object data = element.getData("CLR");
                CLRFactoryTests.assertTrue((boolean)(data instanceof CLR));
                CLR clr = (CLR)data;
                CLRFactoryTests.assertEquals((Object)clr.getFactory(), (Object)CLRFactory.INSTANCE);
            }
        });
    }

    public void testCLRFactoryOption() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryOption.class.getSimpleName()) + ".xwt");
        HashMap<String, Object> options = new HashMap<String, Object>();
        CLRFactory clrFactory = new CLRFactory();
        options.put("XWT.ClassFactory", clrFactory);
        this.runTest(url, options, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.assertTrue((boolean)element.getText().equals(""));
            }
        });
    }

    public void testCLRFactoryGlobalOption() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryOption.class.getSimpleName()) + ".xwt");
        CLRFactory clrFactory = new CLRFactory();
        XWT.setCLRFactory((ICLRFactory)clrFactory);
        this.runTest(url, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.assertTrue((boolean)element.getText().equals(""));
            }
        });
    }

    public void testCLRFactoryPrecedentOption() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryDefault.class.getSimpleName()) + ".xwt");
        HashMap<String, Object> options = new HashMap<String, Object>();
        CLRFadeFactory clrFactory = new CLRFadeFactory();
        options.put("XWT.ClassFactory", clrFactory);
        this.runTest(url, options, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                Object data = element.getData("CLR");
                CLRFactoryTests.assertTrue((boolean)(data instanceof CLR));
            }
        });
    }

    public void testCLRFactoryPrecedentGlobal() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryDefault.class.getSimpleName()) + ".xwt");
        CLRFadeFactory clrFactory = new CLRFadeFactory();
        XWT.setCLRFactory((ICLRFactory)clrFactory);
        this.runTest(url, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                Object data = element.getData("CLR");
                CLRFactoryTests.assertTrue((boolean)(data instanceof CLR));
            }
        });
    }

    public void testCLRFactoryPrecedentOptionOverGlobal() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryOption.class.getSimpleName()) + ".xwt");
        HashMap<String, Object> options = new HashMap<String, Object>();
        CLRFadeFactory clrFadeFactory = new CLRFadeFactory();
        XWT.setCLRFactory((ICLRFactory)clrFadeFactory);
        CLRFactory clrFactory = new CLRFactory();
        options.put("XWT.ClassFactory", clrFactory);
        this.runTest(url, options, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                Object data = element.getData("CLR");
                CLRFactoryTests.assertTrue((boolean)(data instanceof CLR));
            }
        });
    }

    public void testCLRFactoryOptionArg() throws Exception {
        URL url = CLR.class.getResource(String.valueOf(CLRFactoryOptionArgs.class.getSimpleName()) + ".xwt");
        HashMap<String, Object> options = new HashMap<String, Object>();
        CLRFactory clrFactory = new CLRFactory();
        options.put("XWT.ClassFactory", clrFactory);
        this.runTest(url, options, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.this.selectButton(element);
            }
        }, new Runnable(){

            public void run() {
                Button element = (Button)XWT.findElementByName((Object)CLRFactoryTests.this.root, (String)"button");
                CLRFactoryTests.assertTrue((boolean)element.getText().equals("arg1 arg2"));
            }
        });
    }
}

