/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.resources.semantic.test.provider.NullContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.junit.Assert;
import org.junit.Test;

public class TestsNullContentProvider
extends TestsContentProviderUtil {
    public TestsNullContentProvider() {
        super(true, "NullContentProvider", NullContentProvider.class.getName());
    }

    @Test
    public void testNonLockingNonLocal() throws Exception {
        final ISemanticFolder sf = (ISemanticFolder)this.testProject.getFolder("root").getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ISemanticResourceInfo inf = sf.fetchResourceInfo(4, monitor);
                    Assert.assertFalse((String)"Locking should not be supported", (boolean)inf.isLockingSupported());
                }
                catch (CoreException coreException) {}
                IStatus stat = sf.lockResource(TestsNullContentProvider.this.options, monitor);
                Assert.assertFalse((String)"Locking should have failed", (boolean)stat.isOK());
                stat = sf.unlockResource(TestsNullContentProvider.this.options, monitor);
                Assert.assertFalse((String)"Unlocking should have failed", (boolean)stat.isOK());
                try {
                    TestsNullContentProvider.this.testProject.getFolder("root").getFile("New").create((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}), true, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }
}

