/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.script.js.text.scanners;

import org.eclipse.e4.tools.emf.ui.script.js.ResourceProvider;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.FastJavaScriptPartitionScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptCodeScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptCommentScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptDocScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.SingleTokenJavaScanner;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;

public class JavaScriptTextTools {
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    private JavaScriptCodeScanner fCodeScanner;
    private JavaScriptCommentScanner fMultilineCommentScanner;
    private JavaScriptCommentScanner fSinglelineCommentScanner;
    private SingleTokenJavaScanner fStringScanner;
    private JavaScriptDocScanner fJavaDocScanner;

    public JavaScriptTextTools(IResourcePool resourcePool, IPreferenceStore store) {
        this.fCodeScanner = new JavaScriptCodeScanner(resourcePool, store);
        this.fMultilineCommentScanner = new JavaScriptCommentScanner(resourcePool, store, ResourceProvider.JAVA_MULTI_LINE_COMMENT);
        this.fSinglelineCommentScanner = new JavaScriptCommentScanner(resourcePool, store, ResourceProvider.JAVA_SINGLE_LINE_COMMENT);
        this.fStringScanner = new SingleTokenJavaScanner(resourcePool, store, ResourceProvider.JAVA_STRING);
        this.fJavaDocScanner = new JavaScriptDocScanner(resourcePool, store);
    }

    public ITokenScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public ITokenScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public ITokenScanner getStringScanner() {
        return this.fStringScanner;
    }

    public ITokenScanner getJavaDocScanner() {
        return this.fJavaDocScanner;
    }

    public ITokenScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public void setupJavaDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return new FastJavaScriptPartitionScanner();
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        return new FastPartitioner(this.getPartitionScanner(), LEGAL_CONTENT_TYPES);
    }
}

