/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IntroContentParser {
    private static String TAG_INTRO_CONTENT = "introContent";
    private static String TAG_HTML = "html";
    private Document document;
    private boolean hasXHTMLContent;

    public IntroContentParser(String content) {
        try {
            this.document = this.parse(content);
            if (this.document != null) {
                Element rootElement = this.document.getDocumentElement();
                if (rootElement.getTagName().equals(TAG_INTRO_CONTENT)) {
                    this.hasXHTMLContent = false;
                } else if (rootElement.getTagName().equals(TAG_HTML)) {
                    this.hasXHTMLContent = true;
                } else {
                    this.document = null;
                }
            }
        }
        catch (Exception e) {
            Log.error("Could not load Intro content file: " + content, e);
        }
    }

    private Document parse(String fileURI) {
        Document document = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(true);
            docFactory.setExpandEntityReferences(false);
            DocumentBuilder parser = docFactory.newDocumentBuilder();
            parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    return new InputSource(new StringReader(""));
                }
            });
            document = parser.parse(fileURI);
            return document;
        }
        catch (SAXParseException spe) {
            StringBuffer buffer = new StringBuffer("IntroParser error in line ");
            buffer.append(spe.getLineNumber());
            buffer.append(", uri ");
            buffer.append(spe.getSystemId());
            buffer.append("\n");
            buffer.append(spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Log.error(buffer.toString(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Log.error(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            Log.error(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            Log.error(ioe.getMessage(), ioe);
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean hasXHTMLContent() {
        return this.hasXHTMLContent;
    }

    public static String convertToString(Document document) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StringWriter stringBuffer = new StringWriter();
            StreamResult result = new StreamResult(stringBuffer);
            DocumentType docType = document.getDoctype();
            if (docType != null) {
                String value = docType.getSystemId();
                transformer.setOutputProperty("doctype-system", value);
                value = document.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", value);
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                Log.warning("XHTML file used to display this Intro page does not have a Document type defined. XHTML requires document types to be defined.");
            }
            transformer.transform(source, result);
            return stringBuffer.toString();
        }
        catch (TransformerConfigurationException tce) {
            Log.error("Transformer Config error: " + tce.getMessage(), null);
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            Log.error("Transformer Stack trace: ", x);
        }
        catch (TransformerException te) {
            Log.error("Transformer error: " + te.getMessage(), te);
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            Log.error("Transformer Stack trace: ", x);
        }
        return null;
    }
}

