/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;

public class ModelMigrationProcessor {
    private static final String MIGRATION_001 = "ModelMigrationProcessor.001";

    @Execute
    public void process(MApplication application, IEclipseContext context) {
        if (!application.getTags().contains(MIGRATION_001)) {
            application.getTags().add(MIGRATION_001);
            this.removeE4CommandsFromIDE(application);
        }
    }

    private void removeE4CommandsFromIDE(MApplication application) {
        List commands = application.getCommands();
        HashSet<MCommand> toBeRemoved = new HashSet<MCommand>();
        for (MCommand command : commands) {
            String elementId = command.getElementId();
            if ("e4.exit".equals(elementId)) {
                toBeRemoved.add(command);
            } else if ("e4.show.view".equals(elementId)) {
                toBeRemoved.add(command);
            } else if ("org.eclipse.e4.ui.saveCommands".equals(elementId)) {
                toBeRemoved.add(command);
            } else if ("org.eclipse.e4.ui.saveAllCommands".equals(elementId)) {
                toBeRemoved.add(command);
            }
            if (toBeRemoved.size() > 3) break;
        }
        if (toBeRemoved.size() == 0) {
            return;
        }
        List handlers = application.getHandlers();
        Iterator i = handlers.iterator();
        int removed = 0;
        while (i.hasNext() && removed < 4) {
            MHandler handler = (MHandler)i.next();
            if (!toBeRemoved.contains(handler.getCommand())) continue;
            i.remove();
            ++removed;
        }
        List bindingContexts = application.getBindingContexts();
        MBindingContext dialogAndWindow = null;
        for (MBindingContext c : bindingContexts) {
            if (!"org.eclipse.ui.contexts.dialogAndWindow".equals(c.getElementId())) continue;
            dialogAndWindow = c;
            break;
        }
        if (dialogAndWindow != null) {
            List bindingTables = application.getBindingTables();
            MBindingTable dAWTable = null;
            for (MBindingTable table : bindingTables) {
                if (!dialogAndWindow.equals(table.getBindingContext())) continue;
                dAWTable = table;
                break;
            }
            if (dAWTable != null) {
                List bindings = dAWTable.getBindings();
                Iterator j = bindings.iterator();
                removed = 0;
                while (j.hasNext() && removed < 3) {
                    MKeyBinding binding = (MKeyBinding)j.next();
                    if (!toBeRemoved.contains(binding.getCommand())) continue;
                    j.remove();
                    ++removed;
                }
            }
        }
        commands.removeAll(toBeRemoved);
    }
}

