/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.LocationViewer;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchSite;

class OpenLocationAction
extends SelectionDispatchAction {
    private CallHierarchyViewPart fPart;

    public OpenLocationAction(CallHierarchyViewPart part, IWorkbenchSite site) {
        super(site);
        this.fPart = part;
        LocationViewer viewer = this.fPart.getLocationViewer();
        this.setText(CallHierarchyMessages.OpenLocationAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenLocationAction_tooltip);
        this.setEnabled(!this.fPart.getSelection().isEmpty());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenLocationAction.this.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof MethodWrapper || element instanceof CallLocation) continue;
            return false;
        }
        return true;
    }

    public ISelection getSelection() {
        return this.fPart.getSelection();
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            boolean noError = CallHierarchyUI.openInEditor(iter.next(), this.getShell(), OpenStrategy.activateOnOpen());
            if (noError) continue;
            return;
        }
    }
}

