/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.IUpdate;

public class PDEFormEditorContributor
extends MultiPageEditorActionBarContributor {
    protected PDEFormEditor fEditor;
    protected IFormPage fPage;
    private SaveAction fSaveAction;
    protected RevertAction fRevertAction;
    private ClipboardAction fCutAction;
    private ClipboardAction fCopyAction;
    private ClipboardAction fPasteAction;
    private Hashtable<String, Action> fGlobalActions = new Hashtable();
    private ISharedImages fSharedImages;

    public PDEFormEditorContributor(String menuName) {
    }

    private void addGlobalAction(String id) {
        GlobalAction action = new GlobalAction(id);
        this.addGlobalAction(id, action);
    }

    private void addGlobalAction(String id, Action action) {
        this.fGlobalActions.put(id, action);
        this.getActionBars().setGlobalActionHandler(id, (IAction)action);
    }

    public void addClipboardActions(IMenuManager mng) {
        mng.add((IAction)this.fCutAction);
        mng.add((IAction)this.fCopyAction);
        mng.add((IAction)this.fPasteAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.fRevertAction);
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        this.contextMenuAboutToShow(mng, true);
    }

    public void contextMenuAboutToShow(IMenuManager mng, boolean addClipboard) {
        if (this.fEditor != null) {
            this.updateSelectableActions(this.fEditor.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(mng);
        }
        mng.add((IAction)this.fSaveAction);
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public PDEFormEditor getEditor() {
        return this.fEditor;
    }

    public IAction getGlobalAction(String id) {
        return (IAction)this.fGlobalActions.get(id);
    }

    public IAction getSaveAction() {
        return this.fSaveAction;
    }

    public IAction getRevertAction() {
        return this.fRevertAction;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    protected void makeActions() {
        this.fCutAction = new CutAction();
        this.fCopyAction = new CopyAction();
        this.fPasteAction = new PasteAction();
        this.addGlobalAction(ActionFactory.CUT.getId(), this.fCutAction);
        this.addGlobalAction(ActionFactory.COPY.getId(), this.fCopyAction);
        this.addGlobalAction(ActionFactory.PASTE.getId(), this.fPasteAction);
        this.addGlobalAction(ActionFactory.DELETE.getId());
        this.addGlobalAction(ActionFactory.UNDO.getId());
        this.addGlobalAction(ActionFactory.REDO.getId());
        this.addGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.addGlobalAction(ActionFactory.FIND.getId());
        this.addGlobalAction(IDEActionFactory.BOOKMARK.getId());
        this.fSaveAction = new SaveAction();
        this.fSaveAction.setText(PDEUIMessages.EditorActions_save);
        this.fRevertAction = new RevertAction();
        this.fRevertAction.setText(PDEUIMessages.EditorActions_revert);
        this.addGlobalAction(ActionFactory.REVERT.getId(), this.fRevertAction);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof PDESourcePage) {
            PDESourcePage page = (PDESourcePage)targetEditor;
            PDEPlugin.getActivePage().activate((IWorkbenchPart)page.getEditor());
            return;
        }
        if (!(targetEditor instanceof PDEFormEditor)) {
            return;
        }
        this.fEditor = (PDEFormEditor)targetEditor;
        this.fEditor.updateUndo(this.getGlobalAction(ActionFactory.UNDO.getId()), this.getGlobalAction(ActionFactory.REDO.getId()));
        this.setActivePage(this.fEditor.getActiveEditor());
        this.updateSelectableActions(this.fEditor.getSelection());
    }

    public void setActivePage(IEditorPart newEditor) {
        if (this.fEditor == null) {
            return;
        }
        IFormPage oldPage = this.fPage;
        this.fPage = this.fEditor.getActivePageInstance();
        if (this.fPage != null) {
            this.updateActions();
            if (oldPage != null && !oldPage.isEditor() && !this.fPage.isEditor()) {
                this.getActionBars().updateActionBars();
            }
        }
    }

    public void updateActions() {
        this.fSaveAction.update();
        this.fRevertAction.update();
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.fEditor != null) {
            this.fCutAction.selectionChanged(selection);
            this.fCopyAction.selectionChanged(selection);
            this.fPasteAction.selectionChanged(selection);
        }
    }

    public IEditorActionBarContributor getSourceContributor() {
        return null;
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.makeActions();
    }

    protected ISharedImages getSharedImages() {
        if (this.fSharedImages == null) {
            this.fSharedImages = this.getPage().getWorkbenchWindow().getWorkbench().getSharedImages();
        }
        return this.fSharedImages;
    }

    class ClipboardAction
    extends GlobalAction {
        public ClipboardAction(String id) {
            super(id);
            this.setEnabled(false);
        }

        public void selectionChanged(ISelection selection) {
        }

        public boolean isEditable() {
            if (PDEFormEditorContributor.this.fEditor == null) {
                return false;
            }
            IBaseModel model = PDEFormEditorContributor.this.fEditor.getAggregateModel();
            return model instanceof IEditable ? ((IEditable)model).isEditable() : false;
        }
    }

    class CopyAction
    extends ClipboardAction {
        public CopyAction() {
            super(ActionFactory.COPY.getId());
            this.setText(PDEUIMessages.EditorActions_copy);
            this.setImageDescriptor(PDEFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(PDEFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.setActionDefinitionId(ActionFactory.COPY.getCommandId());
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(PDEFormEditorContributor.this.fEditor.canCopy(selection));
        }
    }

    class CutAction
    extends ClipboardAction {
        public CutAction() {
            super(ActionFactory.CUT.getId());
            this.setText(PDEUIMessages.EditorActions_cut);
            this.setImageDescriptor(PDEFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(PDEFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
            this.setActionDefinitionId(ActionFactory.CUT.getCommandId());
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && PDEFormEditorContributor.this.fEditor.canCut(selection));
        }
    }

    class GlobalAction
    extends Action
    implements IUpdate {
        private String id;

        public GlobalAction(String id) {
            this.id = id;
        }

        public void run() {
            PDEFormEditorContributor.this.fEditor.performGlobalAction(this.id);
            PDEFormEditorContributor.this.updateSelectableActions(PDEFormEditorContributor.this.fEditor.getSelection());
        }

        public void update() {
            PDEFormEditorContributor.this.getActionBars().updateActionBars();
        }
    }

    class PasteAction
    extends ClipboardAction {
        public PasteAction() {
            super(ActionFactory.PASTE.getId());
            this.setText(PDEUIMessages.EditorActions_paste);
            this.setImageDescriptor(PDEFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
            this.setDisabledImageDescriptor(PDEFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            this.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && PDEFormEditorContributor.this.fEditor.canPasteFromClipboard());
        }
    }

    class RevertAction
    extends Action
    implements IUpdate {
        public void run() {
            if (PDEFormEditorContributor.this.fEditor != null) {
                PDEFormEditorContributor.this.fEditor.doRevert();
            }
        }

        public void update() {
            this.setEnabled(PDEFormEditorContributor.this.fEditor != null ? PDEFormEditorContributor.this.fEditor.isDirty() : false);
        }
    }

    class SaveAction
    extends Action
    implements IUpdate {
        public void run() {
            if (PDEFormEditorContributor.this.fEditor != null) {
                PDEPlugin.getActivePage().saveEditor((IEditorPart)PDEFormEditorContributor.this.fEditor, false);
            }
        }

        public void update() {
            this.setEnabled(PDEFormEditorContributor.this.fEditor != null ? PDEFormEditorContributor.this.fEditor.isDirty() : false);
        }
    }
}

