/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.java.SearchRepositoriesForIUProposal;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JavaResolutionFactory {
    public static final int TYPE_JAVA_COMPLETION = 1;
    public static final int TYPE_CLASSPATH_FIX = 2;

    public static final Object createRequireBundleProposal(IProject project, ExportPackageDescription desc, int type, int relevance) {
        if (desc.getSupplier() == null) {
            return null;
        }
        RequireBundleManifestChange change = new RequireBundleManifestChange(project, desc, null, null);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    public static final Object createImportPackageProposal(IProject project, ExportPackageDescription desc, int type, int relevance) {
        ImportPackageManifestChange change = new ImportPackageManifestChange(project, desc, null, null);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    public static final IJavaCompletionProposal createSearchRepositoriesProposal(String packageName) {
        return new SearchRepositoriesForIUProposal(packageName);
    }

    public static final Object createExportPackageProposal(IProject project, IPackageFragment pkg, int type, int relevance) {
        ExportPackageChange change = new ExportPackageChange(project, pkg);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    private static final Object createWrapper(AbstractManifestChange change, int type, int relevance) {
        switch (type) {
            case 1: {
                return JavaResolutionFactory.createJavaCompletionProposal(change, relevance);
            }
            case 2: {
                return JavaResolutionFactory.createClasspathFixProposal(change, relevance);
            }
        }
        return null;
    }

    public static final ClasspathFixProcessor.ClasspathFixProposal createClasspathFixProposal(final AbstractManifestChange change, final int relevance) {
        return new ClasspathFixProcessor.ClasspathFixProposal(){

            public Change createChange(IProgressMonitor monitor) throws CoreException {
                return change;
            }

            public String getAdditionalProposalInfo() {
                return change.getDescription();
            }

            public String getDisplayString() {
                return change.getName();
            }

            public Image getImage() {
                return change.getImage();
            }

            public int getRelevance() {
                return relevance;
            }
        };
    }

    public static final IJavaCompletionProposal createJavaCompletionProposal(final AbstractManifestChange change, final int relevance) {
        return new IJavaCompletionProposal(){

            public int getRelevance() {
                return relevance;
            }

            public void apply(IDocument document) {
                try {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }

            public String getAdditionalProposalInfo() {
                return change.getDescription();
            }

            public IContextInformation getContextInformation() {
                return null;
            }

            public String getDisplayString() {
                return change.getName();
            }

            public Image getImage() {
                return change.getImage();
            }

            public Point getSelection(IDocument document) {
                return null;
            }
        };
    }

    private static abstract class AbstractManifestChange
    extends Change {
        private Object fChangeObject;
        private IProject fProject;

        private AbstractManifestChange(IProject project, Object obj) {
            this.fProject = project;
            this.fChangeObject = obj;
        }

        protected Object getChangeObject() {
            return this.fChangeObject;
        }

        protected IProject getProject() {
            return this.fProject;
        }

        public abstract Image getImage();

        public abstract String getDescription();

        protected boolean isUndo() {
            return false;
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public Object getModifiedElement() {
            return this.getProject();
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }
    }

    private static class ExportPackageChange
    extends AbstractManifestChange {
        public ExportPackageChange(IProject project, IPackageFragment fragment) {
            super(project, fragment);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            ModelModification mod = new ModelModification(this.getProject()){

                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    if (model instanceof IBundlePluginModelBase) {
                        IBundle bundle = ((IBundlePluginModelBase)model).getBundleModel().getBundle();
                        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
                        if (header == null) {
                            bundle.setHeader("Export-Package", "");
                            header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
                        }
                        header.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)header, (IPackageFragment)ExportPackageChange.this.getChangeObject(), "version"));
                    }
                }
            };
            PDEModelUtility.modifyModel(mod, (IProgressMonitor)new NullProgressMonitor());
            return null;
        }

        public String getName() {
            return NLS.bind((String)PDEUIMessages.ForbiddenAccessProposal_quickfixMessage, (Object[])new String[]{((IPackageFragment)this.getChangeObject()).getElementName(), this.getProject().getName()});
        }

        public Image getImage() {
            return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_BUNDLE);
        }

        public Object getModifiedElement() {
            IFile file = PDEProject.getManifest((IProject)this.getProject());
            if (file.exists()) {
                return file;
            }
            return super.getModifiedElement();
        }

        public String getDescription() {
            return null;
        }
    }

    private static class ImportPackageManifestChange
    extends AbstractManifestChange {
        private ImportPackageManifestChange(IProject project, ExportPackageDescription desc) {
            super(project, desc);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            PDEModelUtility.modifyModel(new ModelModification(this.getProject()){

                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    if (!(model instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase base = (IBundlePluginModelBase)model;
                    IBundle bundle = base.getBundleModel().getBundle();
                    String pkgId = ((ExportPackageDescription)ImportPackageManifestChange.this.getChangeObject()).getName();
                    IManifestHeader header = bundle.getManifestHeader("Import-Package");
                    if (header == null) {
                        bundle.setHeader("Import-Package", pkgId);
                    } else if (header instanceof ImportPackageHeader) {
                        ImportPackageHeader ipHeader = (ImportPackageHeader)header;
                        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle);
                        String versionAttr = manifestVersion < 2 ? "specification-version" : "version";
                        ImportPackageObject impObject = new ImportPackageObject((ManifestHeader)header, (ExportPackageDescription)ImportPackageManifestChange.this.getChangeObject(), versionAttr);
                        if (!ImportPackageManifestChange.this.isUndo()) {
                            ipHeader.addPackage((PackageObject)impObject);
                        } else {
                            ipHeader.removePackage((PackageObject)impObject);
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            if (!this.isUndo()) {
                return new ImportPackageManifestChange(this.getProject(), (ExportPackageDescription)this.getChangeObject()){

                    public boolean isUndo() {
                        return true;
                    }
                };
            }
            return null;
        }

        public String getDescription() {
            return PDEUIMessages.UnresolvedImportFixProcessor_5;
        }

        public Image getImage() {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUNDLE_OBJ);
        }

        public String getName() {
            if (!this.isUndo()) {
                return MessageFormat.format((String)PDEUIMessages.UnresolvedImportFixProcessor_3, (Object[])new Object[]{((ExportPackageDescription)this.getChangeObject()).getName()});
            }
            return MessageFormat.format((String)PDEUIMessages.UnresolvedImportFixProcessor_4, (Object[])new Object[]{((ExportPackageDescription)this.getChangeObject()).getName()});
        }

        public Object getModifiedElement() {
            IFile file = PDEProject.getManifest((IProject)this.getProject());
            if (file.exists()) {
                return file;
            }
            return super.getModifiedElement();
        }

        /* synthetic */ ImportPackageManifestChange(IProject iProject, ExportPackageDescription exportPackageDescription, ImportPackageManifestChange importPackageManifestChange, ImportPackageManifestChange importPackageManifestChange2) {
            this(iProject, exportPackageDescription);
        }
    }

    private static class RequireBundleManifestChange
    extends AbstractManifestChange {
        private RequireBundleManifestChange(IProject project, ExportPackageDescription desc) {
            super(project, desc);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            PDEModelUtility.modifyModel(new ModelModification(this.getProject()){

                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    if (!(model instanceof IPluginModelBase)) {
                        return;
                    }
                    IPluginModelBase base = (IPluginModelBase)model;
                    String pluginId = ((ExportPackageDescription)RequireBundleManifestChange.this.getChangeObject()).getSupplier().getSymbolicName();
                    if (!RequireBundleManifestChange.this.isUndo()) {
                        IPluginImport impt = base.getPluginFactory().createImport();
                        impt.setId(pluginId);
                        base.getPluginBase().add(impt);
                    } else {
                        IPluginImport[] imports = base.getPluginBase().getImports();
                        int i = 0;
                        while (i < imports.length) {
                            if (imports[i].getId().equals(pluginId)) {
                                base.getPluginBase().remove(imports[i]);
                            }
                            ++i;
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            if (!this.isUndo()) {
                return new RequireBundleManifestChange(this.getProject(), (ExportPackageDescription)this.getChangeObject()){

                    public boolean isUndo() {
                        return true;
                    }
                };
            }
            return null;
        }

        public Image getImage() {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ);
        }

        public String getDescription() {
            return PDEUIMessages.UnresolvedImportFixProcessor_2;
        }

        public String getName() {
            if (!this.isUndo()) {
                return MessageFormat.format((String)PDEUIMessages.UnresolvedImportFixProcessor_0, (Object[])new Object[]{((ExportPackageDescription)this.getChangeObject()).getExporter().getName()});
            }
            return MessageFormat.format((String)PDEUIMessages.UnresolvedImportFixProcessor_1, (Object[])new Object[]{((ExportPackageDescription)this.getChangeObject()).getExporter().getName()});
        }

        public Object getModifiedElement() {
            IFile[] files = new IFile[]{PDEProject.getManifest((IProject)this.getProject()), PDEProject.getPluginXml((IProject)this.getProject())};
            int i = 0;
            while (i < files.length) {
                if (files[i].exists()) {
                    return files[i];
                }
                ++i;
            }
            return super.getModifiedElement();
        }

        /* synthetic */ RequireBundleManifestChange(IProject iProject, ExportPackageDescription exportPackageDescription, RequireBundleManifestChange requireBundleManifestChange, RequireBundleManifestChange requireBundleManifestChange2) {
            this(iProject, exportPackageDescription);
        }
    }
}

