/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.eatop.common.resource.EastADLURIFactory;
import org.eclipse.eatop.common.util.IdentifiableUtil;
import org.eclipse.eatop.examples.editor.internal.Activator;
import org.eclipse.eatop.examples.editor.pages.EastADLContentsTreePage;
import org.eclipse.eatop.examples.editor.pages.OverviewPage;
import org.eclipse.eatop.geastadl.ginfrastructure.gelements.GEAXML;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalFormEditor;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;

public class EastADLFormEditor
extends BasicTransactionalFormEditor
implements IPersistableEditor {
    private static final String MODEL_ELEMENT_APPEARANCE_PROPERTY = "model_element_appearance_property";

    protected void addPages() {
        try {
            Object input = this.getModelRoot();
            if (input instanceof EObject) {
                if (IdentifiableUtil.isIdentifiable((Object)input)) {
                    this.addPage((IFormPage)new OverviewPage((FormEditor)this));
                }
                this.addPage((IFormPage)new EastADLContentsTreePage(this));
            }
        }
        catch (PartInitException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    protected String getEditorInputName() {
        String fragment;
        URI editorInputURI;
        Object modelRoot = this.getModelRoot();
        if (modelRoot instanceof GEAXML) {
            return this.getEditorInput().getName();
        }
        if (modelRoot == null && (editorInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)this.getEditorInput())) != null && (fragment = editorInputURI.fragment()) != null) {
            return EastADLURIFactory.getTrailingAbsoluteQualifiedNameSegment((String)fragment);
        }
        return super.getEditorInputName();
    }

    protected Image getEditorInputImage() {
        IFile file;
        Object modelRoot = this.getModelRoot();
        if (modelRoot instanceof GEAXML && (file = EcoreUIUtil.getFileFromEditorInput((IEditorInput)this.getEditorInput())) != null) {
            IContentType contentType = IDE.getContentType((IFile)file);
            ImageDescriptor imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName(), contentType);
            return ExtendedImageRegistry.getInstance().getImage((Object)imageDescriptor);
        }
        return super.getEditorInputImage();
    }

    public String getTitleToolTip() {
        URI uri;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof URIEditorInput && (uri = EcoreUIUtil.getURIFromEditorInput((IEditorInput)editorInput)).isPlatform()) {
            String path = uri.toPlatformString(true);
            return new Path(path).makeRelative().toString();
        }
        return super.getTitleToolTip();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isShowTypeName() {
        return Activator.getPlugin().getDialogSettings().getBoolean(MODEL_ELEMENT_APPEARANCE_PROPERTY);
    }

    public void setShowTypeName(boolean showTypeName) {
        Activator.getPlugin().getDialogSettings().put(MODEL_ELEMENT_APPEARANCE_PROPERTY, showTypeName);
    }
}

