/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.editor.sections;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.eatop.common.util.IdentifiableUtil;
import org.eclipse.eatop.examples.editor.internal.Activator;
import org.eclipse.eatop.examples.editor.internal.messages.Messages;
import org.eclipse.eatop.examples.editor.internal.widgets.FormWidgetFactory;
import org.eclipse.eatop.examples.editor.internal.widgets.IFormWidgetFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.AbstractFieldFormSection;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.platform.ui.fields.IStringField;
import org.eclipse.sphinx.platform.ui.fields.StringField;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralInformationSection
extends AbstractFieldFormSection {
    private boolean editable;
    private boolean fRefreshingFields = false;
    private boolean fUpdatingModel = false;
    private IStringField fShortNameField;
    private IStringField fLongNameField;

    public GeneralInformationSection(AbstractFormPage formPage, Object sectionInput) {
        this(formPage, sectionInput, 0, true);
    }

    public GeneralInformationSection(AbstractFormPage formPage, Object sectionInput, boolean editable) {
        this(formPage, sectionInput, 0, editable);
    }

    public GeneralInformationSection(AbstractFormPage formPage, Object sectionInput, int style, boolean editable) {
        super(formPage, sectionInput, style);
        this.editable = editable;
        this.title = Messages.GeneralInformationSection_title;
        this.description = Messages.GeneralInformationSection_description;
    }

    protected void createSectionClientContent(IManagedForm managedForm, SectionPart sectionPart, Composite sectionClient) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)sectionPart);
        Assert.isNotNull((Object)sectionClient);
        FormWidgetFactory widgetFactory = new FormWidgetFactory(managedForm.getToolkit());
        Layout layout = sectionClient.getLayout();
        int numColumns = ((TableWrapLayout)layout).numColumns;
        this.createShortNameField(this.sectionInput, widgetFactory, sectionClient, numColumns);
        this.createLongNameField(this.sectionInput, widgetFactory, sectionClient, numColumns);
    }

    private void createShortNameField(final Object sectionInput, IFormWidgetFactory widgetFactory, Composite sectionClient, int numColumns) {
        this.fShortNameField = new StringField((IWidgetFactory)widgetFactory, false);
        this.fShortNameField.setLabelText(Messages.GeneralInformationSection_shortNameField_label);
        this.fShortNameField.setToolTipText(Messages.GeneralInformationSection_shortNameField_toolTip);
        this.fShortNameField.setEnabled(true);
        String shortName = IdentifiableUtil.getShortName((Object)sectionInput);
        this.fShortNameField.setText(shortName);
        this.fShortNameField.fillIntoGrid(sectionClient, numColumns);
        this.fShortNameField.getTextControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
            }

            public void focusLost(FocusEvent evt) {
                TransactionalEditingDomain editingDomain;
                String oldValue;
                String newValue;
                Text text = (Text)evt.widget;
                if (!GeneralInformationSection.this.isRefreshingFields() && GeneralInformationSection.this.isPropertyValueChanged(newValue = text.getText(), oldValue = IdentifiableUtil.getShortName((Object)sectionInput)) && (editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)sectionInput)) != null) {
                    GeneralInformationSection.this.fUpdatingModel = true;
                    try {
                        WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IdentifiableUtil.setShortName((Object)sectionInput, (String)newValue);
                            }
                        }, (String)"setShortName");
                    }
                    catch (OperationCanceledException ex) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                    }
                    catch (ExecutionException ex) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                    }
                    GeneralInformationSection.this.fUpdatingModel = false;
                }
            }
        });
    }

    private void createLongNameField(final Object sectionInput, IFormWidgetFactory widgetFactory, Composite sectionClient, int numColumns) {
        this.fLongNameField = new StringField((IWidgetFactory)widgetFactory, false);
        this.fLongNameField.setLabelText(Messages.GeneralInformationSection_longNameField_label);
        this.fLongNameField.setToolTipText(Messages.GeneralInformationSection_longNameField_toolTip);
        this.fLongNameField.setEnabled(true);
        String longName = IdentifiableUtil.getLongName((Object)sectionInput);
        this.fLongNameField.setText(longName);
        this.fLongNameField.fillIntoGrid(sectionClient, numColumns);
        this.fLongNameField.getTextControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
            }

            public void focusLost(FocusEvent evt) {
                TransactionalEditingDomain editingDomain;
                String oldValue;
                String newValue;
                Text text = (Text)evt.widget;
                if (!GeneralInformationSection.this.isRefreshingFields() && GeneralInformationSection.this.isPropertyValueChanged(newValue = text.getText(), oldValue = IdentifiableUtil.getLongName((Object)sectionInput)) && (editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)sectionInput)) != null) {
                    GeneralInformationSection.this.fUpdatingModel = true;
                    try {
                        WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IdentifiableUtil.setLongName((Object)sectionInput, (String)newValue);
                            }
                        }, (String)"setLongName");
                    }
                    catch (OperationCanceledException ex) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                    }
                    catch (ExecutionException ex) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                    }
                    GeneralInformationSection.this.fUpdatingModel = false;
                }
            }
        });
    }

    private void refreshShortNameField(Object sectionInput) {
        if (this.isControlAccessible(this.fShortNameField.getTextControl())) {
            String shortName = IdentifiableUtil.getShortName((Object)sectionInput);
            this.fShortNameField.setText(shortName);
        }
    }

    private void refreshLongNameField(Object sectionInput) {
        if (this.isControlAccessible(this.fLongNameField.getTextControl())) {
            String longName = IdentifiableUtil.getLongName((Object)sectionInput);
            this.fLongNameField.setText(longName);
        }
    }

    protected final boolean isRefreshingFields() {
        return this.fRefreshingFields;
    }

    protected final void setRefreshingFields(boolean refreshing) {
        this.fRefreshingFields = refreshing;
    }

    public void refreshSection() {
        this.setRefreshingFields(true);
        this.refreshShortNameField(this.sectionInput);
        this.refreshLongNameField(this.sectionInput);
        this.setRefreshingFields(false);
    }

    protected final boolean isPropertyValueChanged(Object newValue, Object oldValue) {
        return oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
    }
}

