/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterDialog;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class JavaDetailFormattersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DETAIL_FORMATTER_IS_ENABLED = "1";
    public static final String DETAIL_FORMATTER_IS_DISABLED = "0";
    private CheckboxTableViewer fFormatterListViewer;
    private Button fAddFormatterButton;
    private Button fRemoveFormatterButton;
    private Button fEditFormatterButton;
    private JDISourceViewer fCodeViewer;
    private Label fTableLabel;
    private FormatterListViewerContentProvider fFormatViewerContentProvider;
    private Button fInlineFormattersButton;
    private Button fInlineAllButton;

    public JavaDetailFormattersPreferencePage() {
        this.setTitle(DebugUIMessages.JavaDetailFormattersPreferencePage_0);
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.JavaDetailFormattersPreferencePage_Override_default___toString_____for_Variables_and_Expressions_view_details__1);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_DETAIL_FORMATTER_PREFERENCE_PAGE);
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(font);
        this.createDetailFormatsPreferences(container);
        this.createLabelPreferences(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void createLabelPreferences(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout());
        group.setText(DebugUIMessages.JavaDetailFormattersPreferencePage_1);
        String preference = this.getPreferenceStore().getString(IJDIPreferencesConstants.PREF_SHOW_DETAILS);
        this.fInlineFormattersButton = new Button((Composite)group, 16);
        this.fInlineFormattersButton.setText(DebugUIMessages.JavaDetailFormattersPreferencePage_2);
        this.fInlineFormattersButton.setSelection(preference.equals("INLINE_FORMATTERS"));
        this.fInlineAllButton = new Button((Composite)group, 16);
        this.fInlineAllButton.setText(DebugUIMessages.JavaDetailFormattersPreferencePage_3);
        this.fInlineAllButton.setSelection(preference.equals("INLINE_ALL"));
        Button detailPane = new Button((Composite)group, 16);
        detailPane.setText(DebugUIMessages.JavaDetailFormattersPreferencePage_4);
        detailPane.setSelection(preference.equals("DETAIL_PANE"));
    }

    private Control createDetailFormatsPreferences(Composite parent) {
        Font font = parent.getFont();
        this.fTableLabel = new Label(parent, 0);
        this.fTableLabel.setText(DebugUIMessages.JavaDetailFormattersPreferencePage__Types_with_detail_formatters__2);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fTableLabel.setLayoutData((Object)gd);
        this.fTableLabel.setFont(font);
        this.fFormatterListViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67618);
        Table table = (Table)this.fFormatterListViewer.getControl();
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(font);
        this.fFormatViewerContentProvider = new FormatterListViewerContentProvider(this.fFormatterListViewer);
        this.fFormatterListViewer.setContentProvider((IContentProvider)this.fFormatViewerContentProvider);
        this.fFormatterListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DetailFormatter) {
                    return ((DetailFormatter)element).getTypeName();
                }
                return null;
            }
        });
        this.fFormatterListViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((DetailFormatter)event.getElement()).setEnabled(event.getChecked());
            }
        });
        this.fFormatterListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)event.getSelection());
            }
        });
        this.fFormatterListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    JavaDetailFormattersPreferencePage.this.editType();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    JavaDetailFormattersPreferencePage.this.removeTypes();
                }
            }
        });
        this.fFormatterListViewer.setInput((Object)this);
        this.createDetailFormatsButtons(parent);
        Label label = new Label(parent, 0);
        label.setText(DebugUIMessages.JavaDetailFormattersPreferencePage_Detail_formatter_code_snippet_defined_for_selected_type__3);
        label.setFont(font);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createSourceViewer(parent);
        this.fFormatViewerContentProvider.refreshViewer();
        return parent;
    }

    private void createDetailFormatsButtons(Composite container) {
        Font font = container.getFont();
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFormatterButton = new Button(buttonContainer, 8);
        this.fAddFormatterButton.setText(DebugUIMessages.JavaDetailFormattersPreferencePage_Add__Formatter____5);
        this.fAddFormatterButton.setToolTipText(DebugUIMessages.JavaDetailFormattersPreferencePage_Allow_you_to_create_a_new_detail_formatter_6);
        this.fAddFormatterButton.setLayoutData((Object)gd);
        this.fAddFormatterButton.setFont(font);
        this.setButtonLayoutData(this.fAddFormatterButton);
        this.fAddFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaDetailFormattersPreferencePage.this.addType();
            }
        });
        this.fEditFormatterButton = new Button(buttonContainer, 8);
        this.fEditFormatterButton.setText(DebugUIMessages.JavaDetailFormattersPreferencePage__Edit____9);
        this.fEditFormatterButton.setToolTipText(DebugUIMessages.JavaDetailFormattersPreferencePage_Edit_the_selected_detail_formatter_10);
        this.fEditFormatterButton.setFont(font);
        this.setButtonLayoutData(this.fEditFormatterButton);
        this.fEditFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaDetailFormattersPreferencePage.this.editType();
            }
        });
        this.fEditFormatterButton.setEnabled(false);
        this.fRemoveFormatterButton = new Button(buttonContainer, 8);
        this.fRemoveFormatterButton.setText(DebugUIMessages.JavaDetailFormattersPreferencePage__Remove_7);
        this.fRemoveFormatterButton.setToolTipText(DebugUIMessages.JavaDetailFormattersPreferencePage_Remove_all_selected_detail_formatters_8);
        this.fRemoveFormatterButton.setFont(font);
        this.setButtonLayoutData(this.fRemoveFormatterButton);
        this.fRemoveFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaDetailFormattersPreferencePage.this.removeTypes();
            }
        });
        this.fRemoveFormatterButton.setEnabled(false);
    }

    public void createSourceViewer(Composite container) {
        this.fCodeViewer = new JDISourceViewer(container, null, 0x2000B00);
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fCodeViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration());
        this.fCodeViewer.setEditable(false);
        this.fCodeViewer.setDocument((IDocument)document);
        Control control = this.fCodeViewer.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        control.setLayoutData((Object)gd);
    }

    private void updatePage(IStructuredSelection selection) {
        this.fRemoveFormatterButton.setEnabled(!selection.isEmpty());
        this.fEditFormatterButton.setEnabled(selection.size() == 1);
        this.updateFormatViewer(selection);
    }

    private void updateFormatViewer(IStructuredSelection selection) {
        if (selection.size() == 1) {
            this.fCodeViewer.getDocument().set(((DetailFormatter)selection.getFirstElement()).getSnippet());
        } else {
            this.fCodeViewer.getDocument().set("");
        }
    }

    public void addType() {
        DetailFormatter detailFormat = new DetailFormatter("", "", true);
        if (new DetailFormatterDialog(this.getShell(), detailFormat, this.fFormatViewerContentProvider.getDefinedTypes(), false).open() == 0) {
            this.fFormatViewerContentProvider.addDetailFormatter(detailFormat);
        }
    }

    public void removeTypes() {
        Object[] all = this.fFormatViewerContentProvider.getElements(null);
        IStructuredSelection selection = (IStructuredSelection)this.fFormatterListViewer.getSelection();
        Object first = selection.getFirstElement();
        int index = -1;
        int i = 0;
        while (i < all.length) {
            Object object = all[i];
            if (object.equals(first)) {
                index = i;
                break;
            }
            ++i;
        }
        this.fFormatViewerContentProvider.removeDetailFormatters(selection.toArray());
        all = this.fFormatViewerContentProvider.getElements(null);
        if (index > all.length - 1) {
            index = all.length - 1;
        }
        if (index >= 0) {
            this.fFormatterListViewer.setSelection((ISelection)new StructuredSelection(all[index]));
        }
    }

    public void editType() {
        IStructuredSelection selection = (IStructuredSelection)this.fFormatterListViewer.getSelection();
        if (new DetailFormatterDialog(this.getShell(), (DetailFormatter)selection.getFirstElement(), null, true, true).open() == 0) {
            this.fFormatterListViewer.refresh();
            this.fFormatViewerContentProvider.refreshViewer();
            this.updatePage(selection);
        }
    }

    public boolean performOk() {
        if (this.fFormatViewerContentProvider != null) {
            this.fFormatViewerContentProvider.saveDetailFormatters();
            String value = "DETAIL_PANE";
            if (this.fInlineAllButton.getSelection()) {
                value = "INLINE_ALL";
            } else if (this.fInlineFormattersButton.getSelection()) {
                value = "INLINE_FORMATTERS";
            }
            JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_SHOW_DETAILS, value);
            this.fCodeViewer.dispose();
        }
        return true;
    }

    public boolean performCancel() {
        if (this.fCodeViewer != null) {
            this.fCodeViewer.dispose();
        }
        return super.performCancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FormatterListViewerContentProvider
    implements IStructuredContentProvider {
        private Set<DetailFormatter> fDetailFormattersSet;
        private List<String> fDefinedTypes;
        private CheckboxTableViewer fViewer;

        public FormatterListViewerContentProvider(CheckboxTableViewer viewer) {
            this.fViewer = viewer;
            String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
            this.fDetailFormattersSet = new TreeSet<DetailFormatter>();
            this.fDefinedTypes = new ArrayList<String>(detailFormattersList.length / 3);
            int i = 0;
            int length = detailFormattersList.length;
            while (i < length) {
                String typeName = detailFormattersList[i++];
                String snippet = detailFormattersList[i++].replace('\u0000', ',');
                boolean enabled = !JavaDetailFormattersPreferencePage.DETAIL_FORMATTER_IS_DISABLED.equals(detailFormattersList[i++]);
                DetailFormatter detailFormatter = new DetailFormatter(typeName, snippet, enabled);
                this.fDetailFormattersSet.add(detailFormatter);
                this.fDefinedTypes.add(typeName);
            }
        }

        public void saveDetailFormatters() {
            String[] values = new String[this.fDetailFormattersSet.size() * 3];
            int i = 0;
            for (DetailFormatter detailFormatter : this.fDetailFormattersSet) {
                values[i++] = detailFormatter.getTypeName();
                values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
                String string = values[i++] = detailFormatter.isEnabled() ? JavaDetailFormattersPreferencePage.DETAIL_FORMATTER_IS_ENABLED : JavaDetailFormattersPreferencePage.DETAIL_FORMATTER_IS_DISABLED;
            }
            String pref = JavaDebugOptionsManager.serializeList(values);
            JavaDetailFormattersPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
        }

        public void addDetailFormatter(DetailFormatter detailFormatter) {
            this.fDetailFormattersSet.add(detailFormatter);
            this.fDefinedTypes.add(detailFormatter.getTypeName());
            this.fViewer.refresh();
            this.refreshViewer();
            StructuredSelection selection = new StructuredSelection((Object)detailFormatter);
            this.fViewer.setSelection((ISelection)selection);
            JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)selection);
        }

        public void removeDetailFormatter(DetailFormatter detailFormatter) {
            this.fDetailFormattersSet.remove(detailFormatter);
            this.fDefinedTypes.remove(detailFormatter.getTypeName());
            this.fViewer.refresh();
            StructuredSelection selection = new StructuredSelection();
            this.fViewer.setSelection((ISelection)selection);
            JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)selection);
        }

        public void removeDetailFormatters(Object[] detailFormatters) {
            int i = 0;
            int length = detailFormatters.length;
            while (i < length) {
                this.fDetailFormattersSet.remove(detailFormatters[i]);
                this.fDefinedTypes.remove(((DetailFormatter)detailFormatters[i]).getTypeName());
                ++i;
            }
            this.fViewer.refresh();
            StructuredSelection selection = new StructuredSelection();
            this.fViewer.setSelection((ISelection)selection);
            JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)selection);
        }

        private void refreshViewer() {
            DetailFormatter[] checkedElementsTmp = new DetailFormatter[this.fDetailFormattersSet.size()];
            int i = 0;
            for (DetailFormatter detailFormatter : this.fDetailFormattersSet) {
                if (!detailFormatter.isEnabled()) continue;
                checkedElementsTmp[i++] = detailFormatter;
            }
            Object[] checkedElements = new DetailFormatter[i];
            System.arraycopy(checkedElementsTmp, 0, checkedElements, 0, i);
            this.fViewer.setAllChecked(false);
            this.fViewer.setCheckedElements(checkedElements);
        }

        public Object[] getElements(Object inputElement) {
            return this.fDetailFormattersSet.toArray();
        }

        public List<String> getDefinedTypes() {
            return this.fDefinedTypes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

