/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class GoToInstanceReferredItemAction
extends BaseSelectionListenerAction {
    protected TreeSelection activeSelection = null;
    protected EObject refObject = null;
    protected EObject refTarget = null;

    public GoToInstanceReferredItemAction(EObject refObject, IStructuredSelection selection) {
        super(GoToInstanceReferredItemAction.extractText(refObject));
        this.refObject = refObject;
        this.activeSelection = (TreeSelection)selection;
        for (EObject ref : ModelSearcher.getInstanceRefChildren((EObject)refObject)) {
            EObject target = ModelSearcher.getInstanceRefTarget((EObject)ref);
            if (target == null) continue;
            this.refTarget = target;
        }
    }

    public void run() {
        if (this.activeSelection != null) {
            TreeSelection typeSelection = this.getRefSelection();
            ExtendedPlatformUI.getActivePage().getActivePart().getSite().getSelectionProvider().setSelection((ISelection)typeSelection);
        }
    }

    private static String extractText(EObject refObject) {
        String text = "";
        text = String.valueOf(refObject.eClass().getName()) + ": ";
        EObject target = null;
        for (EObject ref : ModelSearcher.getInstanceRefChildren((EObject)refObject)) {
            target = ModelSearcher.getInstanceRefTarget((EObject)ref);
        }
        if (target != null) {
            text = String.valueOf(text) + target.eGet(target.eClass().getEStructuralFeature("shortName"));
            text = String.valueOf(text) + " [" + target.eClass().getName() + "]";
        }
        return text;
    }

    private TreeSelection getRefSelection() {
        ArrayList<Object> objectList = new ArrayList<Object>();
        objectList.add(this.refTarget);
        EObject parent = this.refTarget.eContainer();
        objectList.add(parent);
        while (parent.eContainer() != null) {
            parent = parent.eContainer();
            objectList.add(parent);
        }
        this.addHead(objectList);
        Collections.reverse(objectList);
        TreePath treePath = new TreePath(objectList.toArray());
        TreeSelection selection = new TreeSelection(treePath);
        return selection;
    }

    private void addHead(List<Object> objectList) {
        TreePath treePath = this.activeSelection.getPaths()[0];
        objectList.add(treePath.getSegment(1));
        objectList.add(treePath.getSegment(0));
    }
}

