/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptorManager;
import org.eclipse.ui.internal.navigator.sorters.SkeletonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class NavigatorSorterService
implements INavigatorSorterService,
VisibilityAssistant.VisibilityListener {
    private final NavigatorContentService contentService;
    private final Map sorters = new HashMap();
    private INavigatorContentDescriptor[] sortOnlyDescriptors;

    public NavigatorSorterService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.computeSortOnlyDescriptors();
    }

    private synchronized void computeSortOnlyDescriptors() {
        NavigatorContentDescriptor[] allDescriptors = NavigatorContentDescriptorManager.getInstance().getSortOnlyContentDescriptors();
        ArrayList<NavigatorContentDescriptor> sortOnlyList = new ArrayList<NavigatorContentDescriptor>();
        int i = 0;
        while (i < allDescriptors.length) {
            if (this.contentService.isActive(allDescriptors[i].getId())) {
                sortOnlyList.add(allDescriptors[i]);
            }
            ++i;
        }
        this.sortOnlyDescriptors = sortOnlyList.toArray(new INavigatorContentDescriptor[0]);
    }

    @Override
    public ViewerSorter findSorterForParent(Object aParent) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(this.contentService, aParent);
        if (descriptors.length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return SkeletonViewerSorter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerSorter getSorter(CommonSorterDescriptor descriptor) {
        ViewerSorter sorter = null;
        Map map = this.sorters;
        synchronized (map) {
            sorter = (ViewerSorter)this.sorters.get(descriptor);
            if (sorter == null) {
                sorter = descriptor.createSorter();
                this.sorters.put(descriptor, sorter);
            }
        }
        return sorter;
    }

    @Override
    public synchronized ViewerSorter findSorter(INavigatorContentDescriptor source, Object parent, Object lvalue, Object rvalue) {
        CommonSorterDescriptor[] descriptors;
        CommonSorterDescriptorManager dm = CommonSorterDescriptorManager.getInstance();
        int i = 0;
        while (i < this.sortOnlyDescriptors.length) {
            INavigatorContentDescriptor lookupDesc = this.sortOnlyDescriptors[i];
            if (source != null && source.getSequenceNumber() < lookupDesc.getSequenceNumber()) {
                lookupDesc = source;
                source = null;
                --i;
            }
            if ((descriptors = dm.findApplicableSorters(this.contentService, lookupDesc, parent)).length > 0) {
                return this.getSorter(descriptors[0]);
            }
            ++i;
        }
        if (source != null && (descriptors = dm.findApplicableSorters(this.contentService, source, parent)).length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return null;
    }

    @Override
    public Map findAvailableSorters(INavigatorContentDescriptor theSource) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(theSource);
        HashMap<String, ViewerSorter> sorters = new HashMap<String, ViewerSorter>();
        int count = 0;
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId() != null && descriptors[i].getId().length() > 0) {
                sorters.put(descriptors[i].getId(), this.getSorter(descriptors[i]));
            } else {
                sorters.put(String.valueOf(theSource.getId()) + ".sorter." + ++count, this.getSorter(descriptors[i]));
            }
            ++i;
        }
        return sorters;
    }

    @Override
    public void onVisibilityOrActivationChange() {
        this.computeSortOnlyDescriptors();
    }
}

