/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.ArrayTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySuperTypeSet
extends ArrayTypeSet {
    private EnumeratedTypeSet fEnumCache = null;

    public ArraySuperTypeSet(TypeSet s) {
        super(s.getTypeSetEnvironment());
        this.fElemTypeSet = s instanceof SuperTypesOfSingleton || s instanceof SuperTypesSet ? s.lowerBound() : s;
    }

    @Override
    public TType anyMember() {
        return this.getJavaLangObject();
    }

    @Override
    public boolean contains(TType t) {
        if (t.equals(this.getJavaLangObject())) {
            return true;
        }
        if (!(t instanceof ArrayType)) {
            return false;
        }
        ArrayType at = (ArrayType)t;
        TType atElemType = at.getComponentType();
        if (this.fElemTypeSet.contains(atElemType)) {
            return true;
        }
        Iterator<TType> iter = this.fElemTypeSet.iterator();
        while (iter.hasNext()) {
            TType elemType = iter.next();
            if (!TTypes.canAssignTo(elemType, atElemType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TypeSet s) {
        if (s instanceof ArraySuperTypeSet) {
            ArraySuperTypeSet ats = (ArraySuperTypeSet)s;
            return this.fElemTypeSet.containsAll(ats.fElemTypeSet);
        }
        if (s instanceof ArrayTypeSet) {
            ArrayTypeSet ats = (ArrayTypeSet)s;
            return this.fElemTypeSet.containsAll(ats.fElemTypeSet);
        }
        return this.enumerate().containsAll(s);
    }

    @Override
    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        if (s2 instanceof ArraySuperTypeSet) {
            ArraySuperTypeSet ats2 = (ArraySuperTypeSet)s2;
            if (ats2.fElemTypeSet.isUniverse()) {
                return new ArraySuperTypeSet(this.fElemTypeSet);
            }
        } else if (s2 instanceof ArrayTypeSet) {
            ArrayTypeSet ats2 = (ArrayTypeSet)s2;
            if (ats2.fElemTypeSet.isUniverse()) {
                return new ArrayTypeSet(this.fElemTypeSet);
            }
        }
        return super.specialCasesIntersectedWith(s2);
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            TypeSet elemSupers = this.fElemTypeSet.superTypes();
            Iterator<TType> iter = elemSupers.iterator();
            while (iter.hasNext()) {
                TType elemSuper = iter.next();
                this.fEnumCache.add(TTypes.createArrayType(elemSuper, 1));
            }
            this.fEnumCache.add(this.getJavaLangObject());
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    @Override
    public Iterator<TType> iterator() {
        return this.enumerate().iterator();
    }

    @Override
    public TypeSet makeClone() {
        return new ArraySuperTypeSet(this.fElemTypeSet);
    }

    @Override
    public TypeSet superTypes() {
        return this.makeClone();
    }

    @Override
    public TType uniqueUpperBound() {
        return this.getJavaLangObject();
    }

    @Override
    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArraySuperTypeSet) {
            ArraySuperTypeSet other = (ArraySuperTypeSet)obj;
            return this.fElemTypeSet.equals(other.fElemTypeSet);
        }
        return false;
    }

    @Override
    public TypeSet subTypes() {
        return this.getTypeSetEnvironment().getUniverseTypeSet();
    }

    @Override
    public String toString() {
        return "{" + this.fID + ": array-super(" + this.fElemTypeSet + ")}";
    }
}

