/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.common.ui.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.eatop.geastadl.ginfrastructure.gelements.GIdentifiable;
import org.eclipse.eatop.geastadl.ginfrastructure.gelements.GReferrable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.util.EObjectUtil;

public class ModelSearcher {
    private static String INSTANCE_REF_PACK = "_instancerefPackageImpl";
    private static String INSTANCE_REF = "_instanceref";
    private static Map<String, String> prettyPackageNames;

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("systemmodeling", "System Modeling");
        m.put("featuremodeling", "Feature Modeling");
        m.put("vehiclefeaturemodeling", "Vehicle Feature Modeling");
        m.put("functionmodeling", "Function Modeling");
        m.put("hardwaremodeling", "Hardware Modeling");
        m.put("usecases", "Use Cases");
        m.put("verificationvalidation", "Verification && Validation");
        m.put("timingconstraints", "Timing Constraints");
        m.put("safetyconstraints", "Safety Constraints");
        m.put("errormodel", "Error Model");
        m.put("safetyrequirement", "Safety Requirement");
        m.put("safetycase", "Safety Case");
        m.put("genericconstraints", "Generic Constraints");
        m.put("userattributes", "User Attributes");
        m.put("behaviordescription", "Behavior Description");
        m.put("attributequantificationconstraint", "Attribute Quantification Constraint");
        m.put("elements", "Packages and Comments");
        m.put("_instanceref", "Instance References");
        prettyPackageNames = Collections.unmodifiableMap(m);
    }

    public static String getPath(EObject e) {
        EObject container = e.eContainer();
        if (e instanceof GIdentifiable) {
            return String.valueOf(ModelSearcher.getPath(container)) + "/" + ((GIdentifiable)e).gGetShortName();
        }
        if (container != null) {
            return ModelSearcher.getPath(container);
        }
        return "";
    }

    public static ArrayList<EObject> findReferences(EObject target) {
        Collection newReferences = EObjectUtil.getInverseReferences((EObject)target, (boolean)true);
        ArrayList<EObject> newRefs = new ArrayList<EObject>();
        for (EStructuralFeature.Setting ref : newReferences) {
            EObject eo = ref.getEObject();
            if (!ModelSearcher.isReference(target, eo)) continue;
            newRefs.add(eo);
        }
        return newRefs;
    }

    private static boolean isReference(EObject target, EObject ref) {
        if (ref == target.eContainer() || target == ref.eContainer()) {
            return false;
        }
        if (ModelSearcher.isTypeOf(target, ref)) {
            return false;
        }
        if (ref.eClass().eContainer().getClass().getName().endsWith(INSTANCE_REF_PACK)) {
            return false;
        }
        return ref.eContents().contains((Object)target) || ref.eCrossReferences().contains((Object)target);
    }

    public static ArrayList<EObject> findInstanceReferences(EObject target) {
        Collection newReferences = EObjectUtil.getInverseReferences((EObject)target, (boolean)true);
        ArrayList<EObject> newRefs = new ArrayList<EObject>();
        for (EStructuralFeature.Setting ref : newReferences) {
            EObject eo = ref.getEObject();
            if (!ModelSearcher.isInstanceReference(target, eo)) continue;
            newRefs.add(eo);
        }
        return newRefs;
    }

    public static boolean hasInstanceRefChild(EObject parent) {
        boolean result = false;
        for (EObject child : parent.eContents()) {
            result = ModelSearcher.isModelElementInInstanceRefPackage(child);
            if (!result) continue;
            return result;
        }
        return result;
    }

    public static ArrayList<EObject> getInstanceRefChildren(EObject parent) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        for (EObject child : parent.eContents()) {
            if (!ModelSearcher.isModelElementInInstanceRefPackage(child)) continue;
            children.add(child);
        }
        return children;
    }

    public static List<EObject> getAssociationChildren(EObject parent) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        for (EObject child : parent.eContents()) {
            if (!ModelSearcher.isAssociationClassElement(child)) continue;
            children.add(child);
        }
        return children;
    }

    private static boolean isAssociationClassElement(EObject child) {
        return child.eClass().getName().equals("Satisfy") || child.eClass().getName().equals("Refine") || child.eClass().getName().equals("Extend") || child.eClass().getName().equals("Include") || child.eClass().getName().equals("VVCase") || child.eClass().getName().equals("VVTarget");
    }

    public static boolean canCreateInstanceRefChild(EObject target) {
        boolean result = false;
        for (EReference child : target.eClass().getEAllContainments()) {
            result = ModelSearcher.isModelElementInInstanceRefPackage(child);
            if (!result) continue;
            return result;
        }
        return result;
    }

    public static boolean isInstanceRef(EObject target) {
        return ModelSearcher.isModelElementInInstanceRefPackage(target);
    }

    public static boolean isModelElementInInstanceRefPackage(EObject target) {
        EStructuralFeature eStructuralFeature = target.eClass().eContainer().eClass().getEStructuralFeature("name");
        String packageName = target.eClass().eContainer().eGet(eStructuralFeature).toString();
        for (EAnnotation annotation : target.eClass().getEAnnotations()) {
            if (!annotation.getSource().equals("Stereotype") || annotation.getDetails().get((Object)"Stereotype") == null) continue;
            String str = (String)annotation.getDetails().get((Object)"Stereotype");
            return str.equals("instanceRef");
        }
        return packageName.contains(INSTANCE_REF);
    }

    private static boolean isModelElementInInstanceRefPackage(EReference target) {
        EStructuralFeature eStructuralFeature = target.getEType().eContainer().eClass().getEStructuralFeature("name");
        String packageName = target.getEType().eContainer().eGet(eStructuralFeature).toString();
        for (EAnnotation annotation : target.getEType().getEAnnotations()) {
            if (!annotation.getSource().equals("Stereotype") || annotation.getDetails().get((Object)"Stereotype") == null) continue;
            String str = (String)annotation.getDetails().get((Object)"Stereotype");
            return str.equals("instanceRef");
        }
        packageName = ModelSearcher.getOriginalMetamodelPackage((EObject)target.getEType());
        return packageName.contains(INSTANCE_REF);
    }

    private static boolean isInstanceReference(EObject target, EObject ref) {
        if (ref == target.eContainer() || target == ref.eContainer()) {
            return false;
        }
        if (ModelSearcher.isTypeOf(target, ref)) {
            return false;
        }
        return ref.eClass().eContainer().getClass().getName().endsWith(INSTANCE_REF_PACK) && (ref.eContents().contains((Object)target) || ref.eCrossReferences().contains((Object)target));
    }

    public static boolean isTypeOf(EObject typeElement, EObject ref) {
        Object eGet;
        EStructuralFeature eStructuralFeature = ref.eClass().getEStructuralFeature("type");
        if (eStructuralFeature != null && (eGet = ref.eGet(eStructuralFeature)) != null && eGet instanceof EObject) {
            return (EObject)eGet == typeElement;
        }
        return false;
    }

    public static String elementNameInParent(EObject target) {
        String name = target.eContainingFeature().getName();
        name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return name;
    }

    public static String getInstanceRefPathString(EObject instanceRef) {
        try {
            EObject eo;
            EObject target = ModelSearcher.getInstanceRefTarget(instanceRef);
            InstanceRefTreeCompleteSearcher searcher = new InstanceRefTreeCompleteSearcher(target);
            searcher.inputChanged(null, null, EcoreUtil.getRootContainer((EObject)target));
            searcher.getChildren(EcoreUtil.getRootContainer((EObject)target));
            Deque<EObject> path = searcher.findPathToTarget();
            String s = "/";
            while ((eo = path.pollLast()) != null) {
                if (!(eo instanceof GReferrable)) continue;
                s = String.valueOf(s) + ((GReferrable)eo).gGetShortName() + "/";
            }
            if (target instanceof GReferrable) {
                s = String.valueOf(s) + ((GReferrable)target).gGetShortName();
            }
            return s;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getOriginalMetamodelPackage(EObject eo) {
        String annotation = EcoreUtil.getAnnotation((EModelElement)((EModelElement)eo), (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"documentation");
        if (annotation == null) {
            return "";
        }
        String qualifiedName = annotation.substring(annotation.indexOf("<em><b>") + "<em><b>".length(), annotation.lastIndexOf("</b></em>"));
        String packageName = qualifiedName.substring(qualifiedName.indexOf("EAST-ADL.") + "EAST-ADL.".length());
        return packageName;
    }

    public static String getPrettyPackageName(String packageName) {
        if (prettyPackageNames.containsKey(packageName)) {
            return prettyPackageNames.get(packageName);
        }
        Character first = Character.valueOf(packageName.charAt(0));
        if (Character.isLowerCase(first.charValue())) {
            return String.valueOf(Character.toUpperCase(first.charValue())) + packageName.substring(1);
        }
        return packageName;
    }

    public static EObject getInstanceRefTarget(EObject instanceRef) {
        EObject target = null;
        for (EStructuralFeature feature : instanceRef.eClass().getEAllStructuralFeatures()) {
            EAnnotation annotation = feature.getEAnnotation("Stereotype");
            if (annotation == null || !annotation.getDetails().containsValue((Object)"instanceRef.target")) continue;
            target = (EObject)instanceRef.eGet(feature);
        }
        return target;
    }

    public static boolean isRealOrVirtualAncestor(EObject root, EObject target) {
        if (EcoreUtil.isAncestor((EObject)root, (EObject)target)) {
            return true;
        }
        if (ModelSearcher.getEObjectType(root) != null && ModelSearcher.isRealOrVirtualAncestor(ModelSearcher.getEObjectType(root), target)) {
            return true;
        }
        for (EObject obj : root.eContents()) {
            if (!ModelSearcher.isRealOrVirtualAncestor(obj, target)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVirtualAncestor(EObject root, EObject target) {
        if (EcoreUtil.isAncestor((EObject)root, (EObject)target)) {
            return false;
        }
        if (ModelSearcher.getEObjectType(root) != null && ModelSearcher.isRealOrVirtualAncestor(ModelSearcher.getEObjectType(root), target)) {
            return true;
        }
        for (EObject obj : root.eContents()) {
            if (!ModelSearcher.isVirtualAncestor(obj, target)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIndirectRealOrVirtualAncestor(EObject root, EObject target) {
        if (root.eContents().contains((Object)target)) {
            return false;
        }
        if (EcoreUtil.isAncestor((EObject)root, (EObject)target)) {
            return true;
        }
        if (ModelSearcher.getEObjectType(root) != null && ModelSearcher.isRealOrVirtualAncestor(ModelSearcher.getEObjectType(root), target)) {
            return true;
        }
        for (EObject obj : root.eContents()) {
            if (!ModelSearcher.isRealOrVirtualAncestor(obj, target)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVirtualAncestorOrEquals(EObject root, EObject target) {
        if (root.equals(target)) {
            return true;
        }
        if (ModelSearcher.getEObjectType(root) != null && ModelSearcher.isRealOrVirtualAncestor(ModelSearcher.getEObjectType(root), target)) {
            return true;
        }
        for (EObject obj : root.eContents()) {
            if (!ModelSearcher.isVirtualAncestor(obj, target)) continue;
            return true;
        }
        return false;
    }

    private static EObject getEObjectType(EObject parentElement) {
        Object eGet;
        EStructuralFeature eStructuralFeature = parentElement.eClass().getEStructuralFeature("type");
        if (eStructuralFeature != null && (eGet = parentElement.eGet(eStructuralFeature)) != null && eGet instanceof EObject) {
            return (EObject)eGet;
        }
        return null;
    }

    static class InstanceRefTreeCompleteSearcher
    implements ITreeContentProvider {
        private EObject target;

        public InstanceRefTreeCompleteSearcher(EObject target) {
            this.target = target;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashSet<EObject> elements = new HashSet<EObject>();
            for (Object o : (List)inputElement) {
                if (!(o instanceof EObject)) continue;
                elements.add(EcoreUtil.getRootContainer((EObject)((EObject)o)));
            }
            return elements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            HashSet<EObject> children = new HashSet<EObject>();
            Object[] typeChildren = this.addTypeChildren((EObject)parentElement, new Object[0]);
            List<Object> typeChildrenList = Arrays.asList(typeChildren);
            for (EObject eObject : ((EObject)parentElement).eContents()) {
                if (!ModelSearcher.isRealOrVirtualAncestor(eObject, this.target)) continue;
                children.add(eObject);
            }
            for (EObject eObject : typeChildrenList) {
                if (!ModelSearcher.isRealOrVirtualAncestor(eObject, this.target)) continue;
                children.add(eObject);
            }
            if (((EObject)parentElement).eContents().contains((Object)this.target) && children.contains(this.target)) {
                children.remove(this.target);
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element != this.target && ModelSearcher.isRealOrVirtualAncestor((EObject)element, this.target);
        }

        private Object[] addTypeChildren(EObject parentElement, Object[] children) {
            EObject typeEObject = this.getEObjectType(parentElement);
            if (typeEObject != null) {
                ArrayList<Object> childrenList = new ArrayList<Object>();
                if (children != null) {
                    childrenList.addAll(Arrays.asList(children));
                }
                childrenList.addAll((Collection<Object>)typeEObject.eContents());
                return childrenList.toArray();
            }
            return children;
        }

        private EObject getEObjectType(EObject parentElement) {
            Object eGet;
            EStructuralFeature eStructuralFeature = parentElement.eClass().getEStructuralFeature("type");
            if (eStructuralFeature != null && (eGet = parentElement.eGet(eStructuralFeature)) != null && eGet instanceof EObject) {
                return (EObject)eGet;
            }
            return null;
        }

        public Deque<EObject> findPathToTarget() {
            ArrayDeque<EObject> path = new ArrayDeque<EObject>();
            EObject root = EcoreUtil.getRootContainer((EObject)this.target);
            this.findNextPathSegment(root, path);
            return path;
        }

        private boolean findNextPathSegment(EObject root, Deque<EObject> d) {
            if (root.eContents().contains((Object)this.target)) {
                return false;
            }
            if (ModelSearcher.isRealOrVirtualAncestor(root, this.target)) {
                d.addFirst(root);
                Object[] objectArray = this.getChildren(root);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (this.findNextPathSegment((EObject)o, d)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return root == this.target;
        }
    }

    static class InstanceRefTreeSearcher
    implements ITreeContentProvider {
        private EObject target;

        public InstanceRefTreeSearcher(EObject target) {
            this.target = target;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashSet<EObject> elements = new HashSet<EObject>();
            for (Object o : (List)inputElement) {
                if (!(o instanceof EObject)) continue;
                elements.add(EcoreUtil.getRootContainer((EObject)((EObject)o)));
            }
            return elements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            HashSet<EObject> children = new HashSet<EObject>();
            Object[] typeChildren = this.addTypeChildren((EObject)parentElement, new Object[0]);
            List<Object> typeChildrenList = Arrays.asList(typeChildren);
            for (EObject eObject : ((EObject)parentElement).eContents()) {
                if (!ModelSearcher.isVirtualAncestor(eObject, this.target)) continue;
                children.add(eObject);
            }
            for (EObject eObject : typeChildrenList) {
                if (!ModelSearcher.isVirtualAncestor(eObject, this.target)) continue;
                children.add(eObject);
            }
            if (((EObject)parentElement).eContents().contains((Object)this.target) && children.contains(this.target)) {
                children.remove(this.target);
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element != this.target && ModelSearcher.isRealOrVirtualAncestor((EObject)element, this.target);
        }

        private Object[] addTypeChildren(EObject parentElement, Object[] children) {
            EObject typeEObject = this.getEObjectType(parentElement);
            if (typeEObject != null) {
                ArrayList<Object> childrenList = new ArrayList<Object>();
                if (children != null) {
                    childrenList.addAll(Arrays.asList(children));
                }
                childrenList.addAll((Collection<Object>)typeEObject.eContents());
                return childrenList.toArray();
            }
            return children;
        }

        private EObject getEObjectType(EObject parentElement) {
            Object eGet;
            EStructuralFeature eStructuralFeature = parentElement.eClass().getEStructuralFeature("type");
            if (eStructuralFeature != null && (eGet = parentElement.eGet(eStructuralFeature)) != null && eGet instanceof EObject) {
                return (EObject)eGet;
            }
            return null;
        }

        public Deque<EObject> findPathToTarget() {
            ArrayDeque<EObject> path = new ArrayDeque<EObject>();
            EObject root = EcoreUtil.getRootContainer((EObject)this.target);
            this.findNextPathSegment(root, path);
            return path;
        }

        private boolean findNextPathSegment(EObject root, Deque<EObject> d) {
            if (root.eContents().contains((Object)this.target)) {
                return false;
            }
            if (ModelSearcher.isRealOrVirtualAncestor(root, this.target)) {
                d.addFirst(root);
                Object[] objectArray = this.getChildren(root);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (this.findNextPathSegment((EObject)o, d)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return root == this.target;
        }
    }
}

