/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.common.resource.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.artop.eel.common.resource.ExtendedEObjectInputStream;
import org.artop.eel.common.resource.ExtendedEObjectOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.eatop.common.internal.Activator;
import org.eclipse.eatop.common.internal.UUID;
import org.eclipse.eatop.common.internal.messages.Messages;
import org.eclipse.eatop.common.preferences.IEastADLPreferences;
import org.eclipse.eatop.common.resource.EastADLURIFactory;
import org.eclipse.eatop.common.resource.impl.ExtendedEastADLResourceAdapter;
import org.eclipse.eatop.common.util.EastADLObjectUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceImpl;
import org.osgi.framework.Bundle;

public class EastADLXMLResourceImpl
extends XMLPersistenceMappingResourceImpl {
    public static final String OPTION_APPLY_RESOURCE_HANDLER = "APPLY_RESOURCE_HANDLER";
    protected ExtendedEastADLResourceAdapter extendedResource;
    private Map<UUID, UUID> uuids = new HashMap<UUID, UUID>();

    public EastADLXMLResourceImpl(URI uri) {
        super(uri);
        this.extendedResource = new ExtendedEastADLResourceAdapter();
        this.eAdapters().add((Object)this.extendedResource);
    }

    public EObject getEObject(String uriFragment) {
        if (this.getContents().size() > 0) {
            return EastADLURIFactory.getEObject((EObject)this.getContents().get(0), uriFragment);
        }
        return null;
    }

    public String getURIFragment(EObject object) {
        return EastADLURIFactory.getURIFragment(object);
    }

    protected void unloaded(InternalEObject internalEObject) {
        this.extendedResource.unloaded((EObject)internalEObject);
    }

    protected boolean isUuidSyncingEnabled() {
        if (Platform.isRunning()) {
            return (Boolean)IEastADLPreferences.SYNC_UUIDS.get();
        }
        return false;
    }

    public synchronized int getUuidUseCount(UUID uuid) {
        UUID repr = this.uuids.get(uuid);
        return repr == null ? 0 : repr.getUseCount();
    }

    public synchronized void incrUuidUseCount(UUID uuid) {
        if (uuid.getData() != null) {
            UUID repr = this.uuids.get(uuid);
            if (repr == null) {
                repr = uuid;
                this.uuids.put(uuid, repr);
            }
            repr.incrUseCount();
        }
    }

    public synchronized void decrUuidUseCount(UUID uuid) {
        UUID repr;
        if (uuid.getData() != null && (repr = this.uuids.get(uuid)) != null) {
            repr.decrUseCount();
            if (repr.getUseCount() == 0) {
                this.uuids.remove(repr);
            }
        }
    }

    public void syncUUIDs() {
        this.uuids.clear();
        TreeIterator iterator = this.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (!object.eClass().getName().startsWith("ML")) continue;
            iterator.prune();
        }
    }

    protected void loadFromBinaryFile(File binaryFile, Map<?, ?> options) throws IOException {
        InputStream inputStream = new FileInputStream(binaryFile);
        int bufferCapacity = BinaryResourceImpl.getBufferCapacity(options);
        if (bufferCapacity > 0) {
            inputStream = new BufferedInputStream(inputStream, bufferCapacity);
        }
        ExtendedEObjectInputStream eObjectInputStream = new ExtendedEObjectInputStream(inputStream, options){

            protected void preLoadFeatureValues(InternalEObject internalEObject, Map<String, String> destValues) throws IOException {
                int size = this.readCompressedInt();
                int i = 0;
                while (i < size) {
                    String key = this.readString();
                    String dest = this.readString();
                    destValues.put(key, dest);
                    ++i;
                }
            }

            protected void postLoadFeatureValues(InternalEObject internalEObject, Map<String, String> destValues) throws IOException {
                if (destValues != null) {
                    for (String key : destValues.keySet()) {
                        EastADLObjectUtil.setDest((EObject)internalEObject, key, destValues.get(key));
                    }
                }
            }
        };
        eObjectInputStream.loadResource((Resource)this);
    }

    public static File getBinaryFile(File xmlFile) {
        return EastADLXMLResourceImpl.getBinaryPath(xmlFile).toFile();
    }

    private static IPath getBinaryPath(File xmlFile) {
        return Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).append(new Path(xmlFile.getAbsolutePath()).addFileExtension("arbin"));
    }

    protected static boolean isBinaryResourceAsOldAs(File xmlFile) {
        long xmlStamp = xmlFile.lastModified();
        long binaryStamp = EastADLXMLResourceImpl.getBinaryPath(xmlFile).toFile().lastModified();
        return xmlStamp != -1L && binaryStamp >= xmlStamp;
    }

    protected File getXMLFile() {
        File xmlFile = null;
        URI convertedURI = this.uri;
        if (!this.uri.isFile() && this.uri.scheme() != null && this.uri.scheme().matches("[A-Z]")) {
            convertedURI = URI.createFileURI((String)this.uri.toString());
        }
        if ((convertedURI = CommonPlugin.asLocalURI((URI)this.uri)).isFile()) {
            xmlFile = new File(convertedURI.toFileString());
        }
        return xmlFile;
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        TransactionalEditingDomain editingDomain;
        File xmlFile;
        XMLResource.ResourceHandler handler;
        boolean hasLoadedFromBinaryResource = false;
        XMLLoad xmlLoad = this.createXMLLoad();
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        if ((handler = (XMLResource.ResourceHandler)options.get("RESOURCE_HANDLER")) != null) {
            handler.preLoad((XMLResource)this, inputStream, options);
        }
        if (this.useBinaryResources() && EastADLXMLResourceImpl.isBinaryResourceAsOldAs(xmlFile = this.getXMLFile())) {
            this.loadFromBinaryFile(EastADLXMLResourceImpl.getBinaryFile(xmlFile), options);
            hasLoadedFromBinaryResource = true;
        }
        if (!hasLoadedFromBinaryResource) {
            xmlLoad.load((XMLResource)this, inputStream, options);
            xmlLoad = null;
            if (this.useBinaryResources()) {
                this.saveToBinaryResource(options);
            }
        }
        if (handler != null) {
            handler.postLoad((XMLResource)this, inputStream, options);
        }
        if ((editingDomain = TransactionUtil.getEditingDomain((Resource)this)) != null && !editingDomain.isReadOnly((Resource)this) && this.isUuidSyncingEnabled()) {
            this.syncUUIDs();
        }
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        TransactionalEditingDomain editingDomain;
        XMLResource.ResourceHandler handler;
        XMLSave xmlSave = this.createXMLSave();
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        if ((handler = (XMLResource.ResourceHandler)options.get("RESOURCE_HANDLER")) != null) {
            handler.preSave((XMLResource)this, outputStream, options);
        }
        xmlSave.save((XMLResource)this, outputStream, options);
        if (this.useBinaryResources()) {
            this.saveToBinaryResource(options);
        }
        if (handler != null) {
            handler.postSave((XMLResource)this, outputStream, options);
        }
        if ((editingDomain = TransactionUtil.getEditingDomain((Resource)this)) != null && !editingDomain.isReadOnly((Resource)this) && this.isUuidSyncingEnabled()) {
            this.syncUUIDs();
        }
    }

    protected void saveToBinaryResource(Map<?, ?> options) throws IOException {
        File xmlFile = this.getXMLFile();
        File binaryFile = EastADLXMLResourceImpl.getBinaryFile(xmlFile);
        File parentFile = binaryFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        OutputStream outputStream = new FileOutputStream(binaryFile);
        boolean buffer = true;
        int bufferCapacity = BinaryResourceImpl.getBufferCapacity(options);
        if (bufferCapacity > 0) {
            outputStream = new BufferedOutputStream(outputStream, bufferCapacity);
        } else {
            buffer = false;
        }
        try {
            ExtendedEObjectOutputStream eObjectOutputStream = new ExtendedEObjectOutputStream(outputStream, options){

                protected void handleAdvancedFeatures(InternalEObject internalEObject, BinaryResourceImpl.EObjectOutputStream.Check check) throws IOException {
                    Map<String, String> eObjectAbstractDests = EastADLObjectUtil.getEObjectAbstractDests((EObject)internalEObject);
                    if (eObjectAbstractDests != null) {
                        Set<Map.Entry<String, String>> entrySet = eObjectAbstractDests.entrySet();
                        int size = entrySet.size();
                        this.writeCompressedInt(size);
                        for (Map.Entry<String, String> entry : entrySet) {
                            this.writeString(entry.getKey());
                            this.writeString(entry.getValue());
                        }
                    } else {
                        this.writeCompressedInt(0);
                    }
                }
            };
            eObjectOutputStream.saveResource((Resource)this);
        }
        finally {
            if (buffer) {
                outputStream.flush();
            }
            outputStream.close();
        }
    }

    protected void doUnload() {
        super.doUnload();
        this.uuids.clear();
    }

    private static void deleteDirectoryContent(File dir, IProgressMonitor monitor) {
        try {
            String taskName = NLS.bind((String)Messages.clearing_binaryResources, (Object)dir.toString());
            if (dir.isDirectory()) {
                File f;
                File[] listFiles = dir.listFiles();
                monitor.beginTask(taskName, listFiles.length * 1000);
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    f = fileArray[n2];
                    if (!f.isDirectory()) {
                        f.delete();
                        monitor.worked(1000);
                    }
                    ++n2;
                }
                fileArray = listFiles;
                n = listFiles.length;
                n2 = 0;
                while (n2 < n) {
                    f = fileArray[n2];
                    if (f.isDirectory()) {
                        EastADLXMLResourceImpl.deleteDirectoryContent(f, (IProgressMonitor)new SubProgressMonitor(monitor, 999));
                        f.delete();
                        monitor.worked(1);
                    }
                    ++n2;
                }
            } else {
                monitor.beginTask(taskName, 1);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void clearCache(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IPath stateLocation = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle());
        EastADLXMLResourceImpl.deleteDirectoryContent(stateLocation.toFile(), monitor);
    }

    protected boolean useBinaryResources() {
        if (!Platform.isRunning()) {
            return false;
        }
        return (Boolean)IEastADLPreferences.PREF_USE_BINARY_RESOURCE.get();
    }
}

