/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.wizards.pages;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferences;
import org.eclipse.eatop.workspace.ui.internal.Activator;
import org.eclipse.eatop.workspace.ui.internal.messages.Messages;
import org.eclipse.eatop.workspace.ui.messages.ErrorUIMessages;
import org.eclipse.eatop.workspace.ui.messages.WorkspaceUIMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.platform.ui.fields.ComboField;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class EastADLProjectWizardFirstPage
extends WizardPage {
    private String initialProjectFieldValue;
    private Text projectNameField;
    private ReleaseGroup releaseGroup;
    private final String RELEASE_GROUP_TEXT = Messages.page_EastADLPreference_releaseGroupText;
    private ProjectContentsLocationArea locationArea;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public EastADLProjectWizardFirstPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout(this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.createNameGroup(composite);
        this.createLocationGroup(composite);
        this.releaseGroup = this.createReleaseGroup(composite, true);
        this.createAdditionalGroups(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_wizard_page_context");
    }

    protected NameGroup createNameGroup(Composite parent) {
        return new NameGroup(parent);
    }

    protected LocationGroup createLocationGroup(Composite parent) {
        return new LocationGroup(parent);
    }

    protected ReleaseGroup createReleaseGroup(Composite parent, boolean defaultEnabled) {
        return new ReleaseGroup(parent, defaultEnabled);
    }

    protected void createAdditionalGroups(Composite parent) {
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(name.trim());
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    public EastADLReleaseDescriptor getRelease() {
        return this.releaseGroup.getSelectedRelease();
    }

    public void saveDialogSettings() {
        this.releaseGroup.saveDialogSettings();
    }

    void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    protected boolean validatePage() {
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkspaceUIMessages.label_newProjectNameEmpty);
            return false;
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(ErrorUIMessages.error_newProjectExistsMessage);
            return false;
        }
        if (!this.locationArea.isDefault()) {
            String validLocationMessage = this.locationArea.checkValidLocation();
            if (validLocationMessage != null) {
                this.setErrorMessage(validLocationMessage);
                return false;
            }
        } else {
            IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(projectFieldContents);
            if (projectLocation.toFile().exists()) {
                try {
                    String canonicalPath = projectLocation.toFile().getCanonicalPath();
                    Path canonicalLocation = new Path(canonicalPath);
                    String existingName = canonicalLocation.lastSegment();
                    if (!existingName.equals(projectFieldContents)) {
                        this.setErrorMessage(NLS.bind((String)ErrorUIMessages.error_newProjectCaseVariantExists, (Object)projectFieldContents));
                        return false;
                    }
                }
                catch (IOException e) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)e);
                }
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public static boolean detectCaseVariant(IPath location) throws IOException {
        if (location.toFile().exists()) {
            String canonicalPath = location.toFile().getCanonicalPath();
            Path canonicalLocation = new Path(canonicalPath);
            String locationName = location.lastSegment();
            String existingName = canonicalLocation.lastSegment();
            if (!existingName.equals(locationName)) {
                return true;
            }
        }
        return false;
    }

    private Layout initGridLayout(GridLayout gridLayout, boolean margins) {
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        return gridLayout;
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String errorMessage, boolean infoOnly) {
                boolean valid;
                EastADLProjectWizardFirstPage.this.setErrorMessage(errorMessage);
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = EastADLProjectWizardFirstPage.this.validatePage();
                }
                EastADLProjectWizardFirstPage.this.setPageComplete(valid);
            }
        };
    }

    protected class LocationGroup {
        private final Group locGroup;

        public LocationGroup(Composite composite) {
            this.locGroup = new Group(composite, 0);
            this.locGroup.setText(Messages.EastADLProjectWizardFirstPage_location);
            this.locGroup.setFont(composite.getFont());
            this.locGroup.setLayout(EastADLProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            this.locGroup.setLayoutData((Object)new GridData(768));
            EastADLProjectWizardFirstPage.this.locationArea = new ProjectContentsLocationArea(EastADLProjectWizardFirstPage.this.getErrorReporter(), (Composite)this.locGroup);
            if (EastADLProjectWizardFirstPage.this.initialProjectFieldValue != null) {
                EastADLProjectWizardFirstPage.this.locationArea.updateProjectName(EastADLProjectWizardFirstPage.this.initialProjectFieldValue);
            }
            EastADLProjectWizardFirstPage.this.setButtonLayoutData(EastADLProjectWizardFirstPage.this.locationArea.getBrowseButton());
        }
    }

    protected class NameGroup
    implements Listener {
        public NameGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            Label projectLabel = new Label(composite, 0);
            projectLabel.setText(WorkspaceUIMessages.label_newProjectCreationPageName);
            projectLabel.setFont(parent.getFont());
            EastADLProjectWizardFirstPage.this.projectNameField = new Text(composite, 2048);
            GridData data = new GridData(768);
            data.widthHint = 250;
            EastADLProjectWizardFirstPage.this.projectNameField.setLayoutData((Object)data);
            EastADLProjectWizardFirstPage.this.projectNameField.setFont(parent.getFont());
            if (EastADLProjectWizardFirstPage.this.initialProjectFieldValue != null) {
                EastADLProjectWizardFirstPage.this.projectNameField.setText(EastADLProjectWizardFirstPage.this.initialProjectFieldValue);
            }
            EastADLProjectWizardFirstPage.this.projectNameField.addListener(24, (Listener)this);
        }

        public void handleEvent(Event event) {
            EastADLProjectWizardFirstPage.this.setLocationForSelection();
            boolean valid = EastADLProjectWizardFirstPage.this.validatePage();
            EastADLProjectWizardFirstPage.this.setPageComplete(valid);
        }
    }

    protected class ReleaseGroup
    implements IFieldListener,
    SelectionListener {
        private final String LAST_SELECTED_RELEASE_OPTION = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.release";
        private final String LAST_SELECTED_RELEASE_KEY = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.project.release";
        private static final int WORKSPACE_DEFAULT_RELEASE = 0;
        private static final int ALTERNATE_RELEASE = 1;
        private static final String RELEASE_LABEL_PATTERN = "%1s (%2s)";
        private final Group releaseGroup;
        private final SelectionButtonField workspaceDefaultReleaseButton;
        private final SelectionButtonField alternateReleaseButton;
        private final ComboField releaseCombo;
        private final Link configureWorkspaceSettingsLink;
        private List<EastADLReleaseDescriptor> supportedReleases = new ArrayList<EastADLReleaseDescriptor>();

        public ReleaseGroup(Composite composite, boolean defaultEnabled) {
            this.releaseGroup = new Group(composite, 0);
            this.releaseGroup.setFont(composite.getFont());
            this.releaseGroup.setLayoutData((Object)new GridData(768));
            this.releaseGroup.setLayout(EastADLProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.releaseGroup.setText(EastADLProjectWizardFirstPage.this.RELEASE_GROUP_TEXT);
            this.workspaceDefaultReleaseButton = new SelectionButtonField(16);
            this.workspaceDefaultReleaseButton.setLabelText(String.valueOf(Messages.EastADLProjectWizardFirstPage_defaultRelease) + " (" + ((EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.getFromWorkspace()).getName() + ")");
            this.workspaceDefaultReleaseButton.fillIntoGrid((Composite)this.releaseGroup, 2);
            this.workspaceDefaultReleaseButton.addFieldListener((IFieldListener)this);
            this.configureWorkspaceSettingsLink = new Link((Composite)this.releaseGroup, 0);
            this.configureWorkspaceSettingsLink.setFont(this.releaseGroup.getFont());
            this.configureWorkspaceSettingsLink.setText(MessageFormat.format("<a>{0}</a>", Messages.EastADLProjectWizardFirstPage_configureSettings));
            this.configureWorkspaceSettingsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            this.configureWorkspaceSettingsLink.addSelectionListener((SelectionListener)this);
            this.alternateReleaseButton = new SelectionButtonField(16);
            this.alternateReleaseButton.setLabelText(Messages.EastADLProjectWizardFirstPage_label_alternateRelease);
            this.alternateReleaseButton.fillIntoGrid((Composite)this.releaseGroup, 1);
            this.alternateReleaseButton.addFieldListener((IFieldListener)this);
            this.releaseCombo = new ComboField(8);
            this.releaseCombo.fillIntoGrid((Composite)this.releaseGroup, 2);
            this.releaseCombo.addFieldListener((IFieldListener)this);
            this.fillSupportedReleases();
            Combo releaseComboControl = (Combo)this.releaseCombo.getComboControl();
            releaseComboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            releaseComboControl.setVisibleItemCount(10);
            switch (this.getLastSelectedReleaseOption()) {
                case 0: {
                    this.workspaceDefaultReleaseButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.alternateReleaseButton.setSelection(true);
                    break;
                }
                default: {
                    this.workspaceDefaultReleaseButton.setSelection(true);
                }
            }
            this.updateEnableState();
        }

        private void fillSupportedReleases() {
            String selectedReleaseId;
            IMetaModelDescriptor descriptor;
            this.supportedReleases = MetaModelDescriptorRegistry.INSTANCE.getDescriptors((IMetaModelDescriptor)EastADLReleaseDescriptor.INSTANCE, true);
            if (!this.supportedReleases.isEmpty()) {
                String[] items = new String[this.supportedReleases.size()];
                int index = 0;
                while (index < this.supportedReleases.size()) {
                    IMetaModelDescriptor descriptor2 = (IMetaModelDescriptor)this.supportedReleases.get(index);
                    items[index] = String.format(RELEASE_LABEL_PATTERN, descriptor2.getName(), descriptor2.getNamespace());
                    ++index;
                }
                this.releaseCombo.setItems(items);
            }
            if (this.supportedReleases.contains(descriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(selectedReleaseId = this.getLastSelectedReleaseIdentifier()))) {
                this.releaseCombo.selectItem(this.supportedReleases.indexOf(descriptor));
            } else {
                EastADLReleaseDescriptor workspaceRelease = (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.getFromWorkspace();
                if (this.supportedReleases.contains(workspaceRelease)) {
                    this.releaseCombo.selectItem(this.supportedReleases.indexOf(workspaceRelease));
                }
            }
        }

        private int getLastSelectedReleaseOption() {
            IDialogSettings dialogSettings = Activator.getPlugin().getDialogSettings();
            if (dialogSettings.get(this.LAST_SELECTED_RELEASE_OPTION) == null) {
                return 0;
            }
            return dialogSettings.getInt(this.LAST_SELECTED_RELEASE_OPTION);
        }

        private void updateEnableState() {
            this.releaseCombo.setEnabled(this.alternateReleaseButton.isSelected());
            this.configureWorkspaceSettingsLink.setEnabled(this.workspaceDefaultReleaseButton.isSelected());
        }

        private String getLastSelectedReleaseIdentifier() {
            IDialogSettings dialogSettings = Activator.getPlugin().getDialogSettings();
            return dialogSettings.get(this.LAST_SELECTED_RELEASE_KEY);
        }

        private void storeSelectionState(ComboField comboField) {
            IMetaModelDescriptor descriptor;
            int index = comboField.getSelectionIndex();
            if (index > -1 && (descriptor = (IMetaModelDescriptor)this.supportedReleases.get(index)) != null) {
                String item = descriptor.getIdentifier();
                Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_RELEASE_KEY, item);
            }
        }

        public EastADLReleaseDescriptor getSelectedRelease() {
            IMetaModelDescriptor descriptor;
            int index;
            if (this.workspaceDefaultReleaseButton.isSelected()) {
                return (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.getFromWorkspace();
            }
            if (this.alternateReleaseButton.isSelected() && (index = this.releaseCombo.getSelectionIndex()) > -1 && (descriptor = (IMetaModelDescriptor)this.supportedReleases.get(index)) instanceof EastADLReleaseDescriptor) {
                return (EastADLReleaseDescriptor)descriptor;
            }
            return null;
        }

        public void dialogFieldChanged(IField field) {
            this.updateEnableState();
            if (field == this.workspaceDefaultReleaseButton) {
                Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_RELEASE_OPTION, 0);
            } else if (field == this.alternateReleaseButton) {
                Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_RELEASE_OPTION, 1);
            } else if (field == this.releaseCombo && this.alternateReleaseButton.isSelected()) {
                this.storeSelectionState((ComboField)field);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String releasePrefPageId = "org.eclipse.eatop.workspace.ui.preferencePages.eastadl.release";
            PreferencesUtil.createPreferenceDialogOn((Shell)EastADLProjectWizardFirstPage.this.getShell(), (String)releasePrefPageId, (String[])new String[]{releasePrefPageId}, null).open();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void saveDialogSettings() {
        }
    }
}

