/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.eatop.common.metamodel.EastADLMetaModelVersionData;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.internal.Activator;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferenceConstants;
import org.eclipse.eatop.workspace.ui.internal.messages.Messages;
import org.eclipse.eatop.workspace.ui.internal.preferences.ModelConverterDescriptionLabels;
import org.eclipse.eatop.workspace.ui.preferences.EastADLPreferenceMessages;
import org.eclipse.eatop.workspace.ui.preferences.PreferenceAndPropertyPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.IModelConverter;
import org.eclipse.sphinx.emf.resource.IModelConverterDescription;
import org.eclipse.sphinx.emf.resource.ModelConverterRegistry;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveableFilter;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ReleasePreferencePage
extends PreferenceAndPropertyPage {
    private String LABEL_PATTERN = "%1s (release %2s)";
    private static final String PROP_PAGE_ID = "org.eclipse.eatop.workspace.ui.propertyPages.eastadl.release";
    private static final String VERSION_SEPARATOR = ".";
    private static final String OTHER_RESOURCE_VERSION_VALUE = "OTHER";
    private static final String DEFAULT_RESOURCE_VERSION = null;
    private String initialRelease;
    private Group releaseGroup;
    private ComboFieldEditor releaseField;
    private boolean releaseValueChanged = false;
    private String initialResourceVersion;
    private boolean isResourceVersionSameAsOriginal;
    private Composite resourceVersionRadioBox;
    private Label resourceVersionLabel;
    private Combo resourceVersionCombo;
    private ModelConverterDescriptionLabels converterDescriptionLabels;
    final Map<String, EastADLReleaseDescriptor> resourceVersionNamesAndValues = new HashMap<String, EastADLReleaseDescriptor>();

    @Override
    protected String getPreferencePageID() {
        return "org.eclipse.eatop.workspace.ui.preferencePages.eastadl.release";
    }

    @Override
    protected String getPropertyPageID() {
        return PROP_PAGE_ID;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        if (this.isProjectPreferencePage()) {
            return this.getProjectPreferenceStore(this.getProject());
        }
        return this.getWorkspacePreferenceStore();
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return !this.getProjectPreferenceStore(project).isDefault("east_adl_release") || !this.getProjectPreferenceStore(project).isDefault("east_adl_resource_version");
    }

    protected void createFieldEditors() {
        this.addReleaseGroup(this.getFieldEditorParent());
    }

    protected void initialize() {
        super.initialize();
        this.updateRelease(this.initialRelease);
        if (this.isProjectPreferencePage()) {
            this.updateResourceVersionWidgets();
            this.updateResourceVersionCombo(this.initialRelease, this.initialResourceVersion);
        }
    }

    @Override
    protected void enablePreferenceContent(boolean useProjectSpecificSettings) {
        this.releaseField.setEnabled(useProjectSpecificSettings, (Composite)this.releaseGroup);
        this.resourceVersionLabel.setEnabled(useProjectSpecificSettings);
        this.setEnabledDeep(this.resourceVersionRadioBox, useProjectSpecificSettings);
        this.updateResourceVersionWidgets();
    }

    @Override
    protected void useProjectSettingsEnabled() {
        EastADLReleaseDescriptor eastadlRelease = this.detectRelease(this.getProject());
        this.setMessage(NLS.bind((String)EastADLPreferenceMessages.ReleasePreferencePage_detectedRelease, (Object)eastadlRelease.getName()), 1);
        this.updateRelease(eastadlRelease.getIdentifier());
        this.updateResourceVersionCombo((IMetaModelDescriptor)eastadlRelease, DEFAULT_RESOURCE_VERSION);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.isProjectPreferencePage() && event.getSource().equals(this.releaseField) && event.getProperty().equals("field_editor_value")) {
            this.releaseValueChanged = !event.getNewValue().equals(this.initialRelease);
            this.updateResourceVersionCombo((String)event.getNewValue(), DEFAULT_RESOURCE_VERSION);
        }
    }

    public boolean performOk() {
        super.performOk();
        if (!this.isProjectPreferencePage()) {
            return true;
        }
        if (this.useProjectSettings()) {
            String selectedResourceVersion = this.isResourceVersionSameAsOriginal ? "same_as_in_original_resource" : this.getSelectedResourceVersion().getIdentifier();
            this.getPreferenceStore().setValue("east_adl_resource_version", selectedResourceVersion);
        } else {
            this.getPreferenceStore().setToDefault("east_adl_release");
            this.getPreferenceStore().setToDefault("east_adl_resource_version");
            IPreferenceStore workspacePreferenceStore = this.getWorkspacePreferenceStore();
            boolean bl = this.releaseValueChanged = !this.initialRelease.equals(workspacePreferenceStore.getString("east_adl_release"));
        }
        if (this.releaseValueChanged) {
            final boolean[] canceled = new boolean[1];
            final IProject project = this.getProject();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(Messages.error_failedToSaveModelsInWorkbench){

                        public void run() {
                            IWorkbenchWindow[] windows;
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                                window = windows[0];
                            }
                            if (window != null) {
                                canceled[0] = !PlatformUI.getWorkbench().saveAll((IShellProvider)window, (IRunnableContext)window, (ISaveableFilter)new BasicModelSaveableFilter(project), true);
                            } else {
                                ModelSaveManager.INSTANCE.saveProject(project, false, null);
                                canceled[0] = false;
                            }
                        }
                    });
                }
            });
            if (canceled[0]) {
                return false;
            }
            Set projectGroup = ExtendedPlatform.getProjectGroup((IProject)project, (boolean)true);
            for (IProject proj : projectGroup) {
                ModelSaveManager.INSTANCE.setSaved((IContainer)proj);
            }
            ModelLoadManager.INSTANCE.reloadProject(project, false, (IMetaModelDescriptor)EastADLReleaseDescriptor.INSTANCE, true, null);
        }
        return true;
    }

    private void addReleaseGroup(Composite parent) {
        GridLayout gridLayout;
        GridData gridData;
        this.getWorkspacePreferenceStore().setDefault("east_adl_release", IEastADLWorkspacePreferenceConstants.PREF_EAST_ADL_RELEASE_DEFAULT);
        if (this.isProjectPreferencePage()) {
            this.getPreferenceStore().setDefault("east_adl_release", this.getWorkspacePreferenceStore().getString("east_adl_release"));
        }
        this.initialRelease = this.getPreferenceStore().getString("east_adl_release");
        this.releaseGroup = new Group(parent, 0);
        this.releaseGroup.setText(EastADLPreferenceMessages.ReleasePreferencePage_releaseGroupText);
        List supportedReleases = MetaModelDescriptorRegistry.INSTANCE.getDescriptors((IMetaModelDescriptor)EastADLReleaseDescriptor.INSTANCE, true);
        String[][] entryNamesAndValues = new String[supportedReleases.size()][2];
        int index = 0;
        while (index < supportedReleases.size()) {
            EastADLReleaseDescriptor eastadlRelease = (EastADLReleaseDescriptor)supportedReleases.get(index);
            entryNamesAndValues[index][0] = String.format(this.LABEL_PATTERN, eastadlRelease.getName(), this.getVersionNumber(eastadlRelease));
            entryNamesAndValues[index][1] = eastadlRelease.getIdentifier();
            ++index;
        }
        this.releaseField = new ComboFieldEditor("east_adl_release", EastADLPreferenceMessages.ReleasePreferencePage_releaseFieldLabel, entryNamesAndValues, (Composite)this.releaseGroup);
        this.addField((FieldEditor)this.releaseField);
        if (this.isProjectPreferencePage()) {
            gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 2;
            this.releaseGroup.setLayoutData((Object)gridData);
            gridLayout = new GridLayout(2, false);
            this.releaseGroup.setLayout((Layout)gridLayout);
        } else {
            gridData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            this.releaseGroup.setLayoutData((Object)gridData);
            gridLayout = new GridLayout(2, false);
            this.releaseGroup.setLayout((Layout)gridLayout);
        }
        if (this.isProjectPreferencePage()) {
            this.initialResourceVersion = this.getPreferenceStore().isDefault("east_adl_resource_version") ? "same_as_in_original_resource" : this.getPreferenceStore().getString("east_adl_resource_version");
            this.isResourceVersionSameAsOriginal = this.initialResourceVersion.equals("same_as_in_original_resource");
            this.resourceVersionLabel = new Label((Composite)this.releaseGroup, 16384);
            this.resourceVersionLabel.setText(EastADLPreferenceMessages.ReleasePreferencePage_resourceVersionLabel);
            gridData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            this.resourceVersionLabel.setLayoutData((Object)gridData);
            this.resourceVersionRadioBox = new Composite((Composite)this.releaseGroup, 0);
            gridData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            this.resourceVersionRadioBox.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 8;
            this.resourceVersionRadioBox.setLayout((Layout)gridLayout);
            this.createResourceVersionRadioButton(EastADLPreferenceMessages.ReleasePreferencePage_sameAsInOriginalButtonLabel, "same_as_in_original_resource", this.isResourceVersionSameAsOriginal);
            this.createResourceVersionRadioButton(EastADLPreferenceMessages.ReleasePreferencePage_otherResourceVersionButtonLabel, OTHER_RESOURCE_VERSION_VALUE, !this.isResourceVersionSameAsOriginal);
            this.resourceVersionCombo = new Combo((Composite)this.releaseGroup, 8);
            gridData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(16);
            this.resourceVersionCombo.setLayoutData((Object)gridData);
            this.resourceVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReleasePreferencePage.this.updateConverterDescriptionArea();
                }
            });
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.releaseGroup, 2560);
            GridData gridData2 = new GridData(4, 4, true, true);
            gridData2.horizontalSpan = 2;
            gridData2.horizontalIndent = this.convertHorizontalDLUsToPixels(16);
            scrolledComposite.setLayoutData((Object)gridData2);
            this.converterDescriptionLabels = new ModelConverterDescriptionLabels((Composite)scrolledComposite);
            scrolledComposite.setContent((Control)this.converterDescriptionLabels);
            scrolledComposite.setMinHeight(this.convertHeightInCharsToPixels(3));
            scrolledComposite.setAlwaysShowScrollBars(true);
        }
        Dialog.applyDialogFont((Control)this.releaseGroup);
    }

    private String getVersionNumber(EastADLReleaseDescriptor releaseDesc) {
        EastADLMetaModelVersionData versionData = releaseDesc.getEastADLVersionData();
        StringBuilder versionNumber = new StringBuilder();
        versionNumber.append(versionData.getMajor());
        versionNumber.append(VERSION_SEPARATOR);
        versionNumber.append(versionData.getMinor());
        versionNumber.append(VERSION_SEPARATOR);
        versionNumber.append(versionData.getRevision());
        return versionNumber.toString();
    }

    private void updateRelease(String eastadlReleaseId) {
        String value = this.getPreferenceStore().getString("east_adl_release");
        this.getPreferenceStore().setValue("east_adl_release", eastadlReleaseId);
        this.releaseField.load();
        this.getPreferenceStore().setValue("east_adl_release", value);
    }

    private void updateResourceVersionCombo(IMetaModelDescriptor eastadlRelease, String resourceVersion) {
        ArrayList<EastADLReleaseDescriptor> relevantVersions = new ArrayList<EastADLReleaseDescriptor>();
        List converters = ModelConverterRegistry.INSTANCE.getConverters();
        for (IModelConverter modelConverter : converters) {
            if (!modelConverter.getMetaModelVersionDescriptor().equals(eastadlRelease)) continue;
            relevantVersions.add((EastADLReleaseDescriptor)modelConverter.getResourceVersionDescriptor());
        }
        Collections.sort(relevantVersions);
        String[] resourceVersionNames = new String[relevantVersions.size()];
        int i = 0;
        int selectedIndex = 0;
        for (EastADLReleaseDescriptor relevantVersion : relevantVersions) {
            String name;
            resourceVersionNames[i] = name = "EAST-ADL " + this.getVersionNumber(relevantVersion);
            String identifier = relevantVersion.getIdentifier();
            this.resourceVersionNamesAndValues.put(name, relevantVersion);
            if (identifier.equals(resourceVersion)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.resourceVersionCombo.setItems(resourceVersionNames);
        if (relevantVersions.size() > 0) {
            this.resourceVersionCombo.select(selectedIndex);
        }
        this.updateConverterDescriptionArea();
    }

    private void updateResourceVersionCombo(String eastadlReleaseId, String resourceVersion) {
        IMetaModelDescriptor eastadlRelease = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(eastadlReleaseId);
        this.updateResourceVersionCombo(eastadlRelease, resourceVersion);
    }

    private void updateConverterDescriptionArea() {
        Collection convDescs;
        EastADLReleaseDescriptor eastadlRelease;
        if (!this.isResourceVersionSameAsOriginal && (eastadlRelease = this.getSelectedResourceVersion()) != null && (convDescs = ModelConverterRegistry.INSTANCE.getConverterDescriptions((IMetaModelDescriptor)this.getSelectedResourceVersion())).size() > 0) {
            this.converterDescriptionLabels.setConverterDescription((IModelConverterDescription)convDescs.iterator().next());
            this.setEnabledDeep(this.converterDescriptionLabels, true);
            return;
        }
        this.converterDescriptionLabels.setConverterDescription(null);
        this.setEnabledDeep(this.converterDescriptionLabels, false);
    }

    private void updateResourceVersionWidgets() {
        boolean enabled = !this.isResourceVersionSameAsOriginal && this.useProjectSettings();
        this.resourceVersionCombo.setEnabled(enabled);
        this.setEnabledDeep(this.converterDescriptionLabels, enabled);
    }

    private EastADLReleaseDescriptor getSelectedResourceVersion() {
        int selectedIndex = this.resourceVersionCombo.getSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        String selectedName = this.resourceVersionCombo.getItem(selectedIndex);
        return this.resourceVersionNamesAndValues.get(selectedName);
    }

    private Button createResourceVersionRadioButton(String label, String value, boolean selected) {
        Button radio = new Button(this.resourceVersionRadioBox, 16400);
        radio.setText(label);
        radio.setData((Object)value);
        radio.setSelection(selected);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String value = (String)event.widget.getData();
                ReleasePreferencePage.this.isResourceVersionSameAsOriginal = value.equals("same_as_in_original_resource");
                ReleasePreferencePage.this.updateResourceVersionWidgets();
                ReleasePreferencePage.this.updateConverterDescriptionArea();
            }
        });
        return radio;
    }

    private void setEnabledDeep(Composite parent, boolean isEnabled) {
        parent.setEnabled(isEnabled);
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(isEnabled);
            ++n2;
        }
    }

    private EastADLReleaseDescriptor detectRelease(IProject project) {
        Collection files = ExtendedPlatform.getAllFiles((IProject)project, (boolean)true);
        for (IFile file : files) {
            IMetaModelDescriptor mmDescriptorFromFirstFile = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(file);
            if (!(mmDescriptorFromFirstFile instanceof EastADLReleaseDescriptor)) continue;
            return (EastADLReleaseDescriptor)mmDescriptorFromFirstFile;
        }
        return (EastADLReleaseDescriptor)MetaModelDescriptorRegistry.INSTANCE.getDescriptor(IEastADLWorkspacePreferenceConstants.PREF_EAST_ADL_RELEASE_DEFAULT);
    }

    private IPreferenceStore getProjectPreferenceStore(IProject project) {
        return new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), Activator.getPlugin().getBundle().getSymbolicName());
    }

    private IPreferenceStore getWorkspacePreferenceStore() {
        return org.eclipse.eatop.workspace.ui.internal.Activator.getPlugin().getWorkspacePreferenceStore();
    }
}

