/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EastADLObjectUtil {
    private static Map<EObject, Map<String, String>> eaObjectToAbstractDests = Collections.synchronizedMap(new WeakHashMap());

    public static boolean isEaObject(Object object) {
        if (object instanceof EObject) {
            return object.getClass().getName().matches("eastadl\\d\\w\\..*");
        }
        return false;
    }

    public static boolean isEastADLResource(Resource resource) {
        EList contents;
        if (resource != null && (contents = resource.getContents()).size() > 0) {
            return EastADLObjectUtil.isEaObject(contents.get(0));
        }
        return false;
    }

    public static Map<String, String> getEObjectAbstractDests(EObject referenceContainer) {
        return eaObjectToAbstractDests.get(referenceContainer);
    }

    public static String getDest(EObject referenceContainer, int featureID, int index) {
        String dest = null;
        Map<String, String> featureIDAndIndexToDest = eaObjectToAbstractDests.get(referenceContainer);
        if (featureIDAndIndexToDest != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(featureID);
            buffer.append(" ");
            buffer.append(index);
            dest = featureIDAndIndexToDest.get(buffer.toString());
        }
        return dest;
    }

    public static void setDest(EObject referenceContainer, int featureID, int index, String dest) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(featureID);
        buffer.append(" ");
        buffer.append(index);
        EastADLObjectUtil.setDest(referenceContainer, buffer.toString(), dest);
    }

    public static void shiftDestUp(EObject referenceContainer, int featureID, int startIndex, int endIndex) {
        Map<String, String> destMap = eaObjectToAbstractDests.get(referenceContainer);
        if (destMap != null) {
            int index = endIndex;
            while (index >= startIndex) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(featureID);
                buffer.append(" ");
                buffer.append(index);
                String dest = destMap.get(buffer.toString());
                if (dest != null) {
                    destMap.remove(buffer.toString());
                    buffer = new StringBuilder();
                    buffer.append(featureID);
                    buffer.append(" ");
                    buffer.append(index + 1);
                    destMap.put(buffer.toString(), dest);
                }
                --index;
            }
        }
    }

    public static void shiftDestDown(EObject referenceContainer, int featureID, int startIndex, int endIndex) {
        Map<String, String> destMap = eaObjectToAbstractDests.get(referenceContainer);
        if (destMap != null) {
            int index = startIndex;
            while (index <= endIndex) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(featureID);
                buffer.append(" ");
                buffer.append(index);
                String dest = destMap.get(buffer.toString());
                if (dest != null) {
                    destMap.remove(buffer.toString());
                    buffer = new StringBuilder();
                    buffer.append(featureID);
                    buffer.append(" ");
                    buffer.append(index - 1);
                    destMap.put(buffer.toString(), dest);
                }
                ++index;
            }
        }
    }

    public static void setDest(EObject referenceContainer, String key, String dest) {
        Map<String, String> featureIDAndIndexToDest = eaObjectToAbstractDests.get(referenceContainer);
        if (featureIDAndIndexToDest == null && dest != null) {
            featureIDAndIndexToDest = new HashMap<String, String>();
            eaObjectToAbstractDests.put(referenceContainer, featureIDAndIndexToDest);
        }
        if (featureIDAndIndexToDest != null) {
            if (dest == null) {
                featureIDAndIndexToDest.remove(key);
                if (featureIDAndIndexToDest.isEmpty()) {
                    eaObjectToAbstractDests.remove(referenceContainer);
                }
            } else {
                featureIDAndIndexToDest.put(key, dest);
            }
        }
    }
}

