/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.serialization.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.eatop.common.metamodel.EastADLMetaModelVersionData;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.serialization.internal.ExtendedXMLPersistenceMappingSaveImpl;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.IModelConverter;
import org.xml.sax.InputSource;

public class EastADLXMLSaveImpl
extends ExtendedXMLPersistenceMappingSaveImpl {
    private static final String SCHEMA_BASE = "eastadl";
    private static final String SCHEMA_EXTENSION = "xsd";

    public EastADLXMLSaveImpl(XMLHelper helper) {
        super(helper);
    }

    protected void saveReferencedHREFWithTypeSaved(EStructuralFeature f, EObject remote, String qname, boolean doSaveType) {
        String href = this.helper.getHREF(remote);
        if (href != null) {
            href = this.convertURI(href);
            EClass eClass = remote.eClass();
            this.doc.startElement(qname);
            this.saveTypeAttribute(f, eClass);
            this.doc.endContentElement(href);
        }
    }

    protected void saveEReferenceReferenced1100Many(InternalEList<? extends EObject> values, EStructuralFeature f) {
        int size = values.size();
        this.doc.startElement(this.getFeatureWrapperQName(f));
        int i = 0;
        while (i < size) {
            EObject value = (EObject)values.basicGet(i);
            String qname = this.getFeatureQName(f);
            this.saveReferencedHREFWithTypeSaved(f, value, qname, true);
            ++i;
        }
        this.doc.endElement();
    }

    protected void saveEReferenceReferenced0100Single(EObject remote, EStructuralFeature f) {
        String qname = this.getFeatureQName(f);
        this.saveReferencedHREFWithTypeSaved(f, remote, qname, true);
    }

    @Override
    protected void addNamespaceDeclarations() {
        IMetaModelDescriptor release = MetaModelDescriptorRegistry.INSTANCE.getDescriptor((Resource)this.helper.getResource());
        boolean isSingleNsReleaseResource = this.isSingleNsRelease((EastADLReleaseDescriptor)release);
        Map originalSchemaCatalog = (Map)this.getDefaultSaveOptions().get("SCHEMA_LOCATION_CATALOG");
        IModelConverter originalConverter = this.converter;
        if (isSingleNsReleaseResource) {
            if (this.converter != null) {
                if (this.converter.getResourceVersionDescriptor() != release) {
                    this.setSchemaLocationFromConverter();
                }
            } else {
                Map<String, String> schemaLocationMap = this.getSchemaLocationMap();
                if (!schemaLocationMap.isEmpty()) {
                    this.setSchemaCatalog(schemaLocationMap);
                    this.converter = new SingleNsReleaseConverter(release);
                }
            }
        }
        super.addNamespaceDeclarations();
        if (isSingleNsReleaseResource) {
            this.setSchemaCatalog(originalSchemaCatalog);
            this.converter = originalConverter;
        }
    }

    private Map<String, String> getSchemaLocationMap() {
        EObject schemaLocationRoot = this.getSchemaLocationRoot((EObject)this.helper.getResource().getContents().get(0));
        EReference xsiSchemaLocationMapFeature = this.extendedMetaData.getXSISchemaLocationMapFeature(schemaLocationRoot.eClass());
        if (xsiSchemaLocationMapFeature != null) {
            return ((EMap)schemaLocationRoot.eGet((EStructuralFeature)xsiSchemaLocationMapFeature)).map();
        }
        return null;
    }

    private void setSchemaLocationFromConverter() {
        EastADLReleaseDescriptor revision = (EastADLReleaseDescriptor)this.converter.getResourceVersionDescriptor();
        Map<String, String> converterSchemaCatalog = this.createSchemaCatalog(revision);
        this.setSchemaCatalog(converterSchemaCatalog);
        Map<String, String> schemaLocationMap = this.getSchemaLocationMap();
        schemaLocationMap.put(revision.getNamespace(), converterSchemaCatalog.get(revision.getNamespace()));
    }

    private void setSchemaCatalog(Map<String, String> schemaCatalog) {
        this.getDefaultSaveOptions().put("SCHEMA_LOCATION_CATALOG", schemaCatalog);
    }

    private boolean isSingleNsRelease(EastADLReleaseDescriptor release) {
        if (release == null) {
            return false;
        }
        List revisionUris = release.getCompatibleNamespaceURIs();
        if (revisionUris.isEmpty()) {
            return false;
        }
        for (java.net.URI revisionUri : revisionUris) {
            if (revisionUri.equals(release.getNamespaceURI())) continue;
            return false;
        }
        return true;
    }

    private Map<Object, Object> getDefaultSaveOptions() {
        return this.helper.getResource().getDefaultSaveOptions();
    }

    private Map<String, String> createSchemaCatalog(EastADLReleaseDescriptor revision) {
        HashMap<String, String> schemaCatalog = new HashMap<String, String>();
        schemaCatalog.put(revision.getNamespace(), this.getSchemaLocation(revision));
        return schemaCatalog;
    }

    public String getSchemaLocation(EastADLReleaseDescriptor revision) {
        return "eastadl_" + this.getSchemaReleaseNumber(revision) + "." + SCHEMA_EXTENSION;
    }

    private String getSchemaReleaseNumber(EastADLReleaseDescriptor revision) {
        EastADLMetaModelVersionData avd = revision.getEastADLVersionData();
        return String.valueOf(avd.getMajor()) + "-" + avd.getMinor() + "-" + avd.getRevision();
    }

    private class SingleNsReleaseConverter
    implements IModelConverter {
        private IMetaModelDescriptor fRelease;

        public SingleNsReleaseConverter(IMetaModelDescriptor release) {
            this.fRelease = release;
        }

        public IMetaModelDescriptor getMetaModelVersionDescriptor() {
            return this.fRelease;
        }

        public IMetaModelDescriptor getResourceVersionDescriptor() {
            return this.fRelease;
        }

        public boolean isLoadConverterFor(XMLResource resource, Map<?, ?> options) {
            return false;
        }

        public boolean isSaveConverterFor(XMLResource resource, Map<?, ?> options) {
            return false;
        }

        public InputSource convertLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) throws IOException {
            return null;
        }

        public void convertSave(XMLString xml, int flushThreshold, URI uri, OutputStream outputStream, String encoding, XMLHelper helper, Map<?, ?> options) throws IOException {
        }

        public void addExtraAttributesToSavedRootElement(XMLString rootElement, Map<?, ?> options) {
        }

        public void dispose() {
        }
    }
}

