/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.jobs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public class CreateEastADLFileJob
extends WorkspaceJob {
    protected static final String EAST_ADL_TYPE_NAME = "EAXML";
    protected static final String EAPACKAGE_TYPE_NAME = "EAPackage";
    protected static final String SHORTNAME_FEATURE_NAME = "shortName";
    protected static final String TOPLEVELPACKAGES_FEATURE_NAME = "topLevelPackage";
    protected static final String TOPLEVELPACKAGES_TYPE_NAME = "EAPackage";
    protected static final String EAPACKAGES_FEATURE_NAME = "subPackage";
    private final IFile eastadlFile;
    private final String eaPackageName;
    private final EastADLReleaseDescriptor eastadlRelease;

    public CreateEastADLFileJob(String jobName, IFile eastadlFile, EastADLReleaseDescriptor eastadlRelease, String eaPackageName) {
        super(jobName);
        Assert.isNotNull((Object)eastadlFile);
        if (eastadlRelease == null) {
            eastadlRelease = (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.get(eastadlFile.getProject());
        }
        this.eastadlFile = eastadlFile;
        this.eastadlRelease = eastadlRelease;
        this.eaPackageName = eaPackageName;
        this.setPriority(40);
        this.setRule(ExtendedPlatform.createSaveNewSchedulingRule((IResource)eastadlFile));
    }

    public CreateEastADLFileJob(String jobName, IFile eastadlFile, String eaPackageName) {
        this(jobName, eastadlFile, null, eaPackageName);
    }

    protected EastADLReleaseDescriptor getEastADLRelease() {
        return this.eastadlRelease;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        EClass eastadlType = (EClass)this.eastadlRelease.getRootEPackage().getEClassifier(EAST_ADL_TYPE_NAME);
        EObject rootObject = this.eastadlRelease.getRootEFactory().create(eastadlType);
        if (this.eaPackageName != null) {
            EClass eaPackageType = (EClass)this.eastadlRelease.getRootEPackage().getEClassifier("EAPackage");
            EObject eaPackage = this.eastadlRelease.getRootEFactory().create(eaPackageType);
            EStructuralFeature shortNameFeature = eaPackageType.getEStructuralFeature(SHORTNAME_FEATURE_NAME);
            eaPackage.eSet(shortNameFeature, (Object)this.eaPackageName);
            EStructuralFeature topLevelPackagesFeature = eastadlType.getEStructuralFeature(TOPLEVELPACKAGES_FEATURE_NAME);
            EClass topLevelPackageType = (EClass)this.eastadlRelease.getRootEPackage().getEClassifier("EAPackage");
            EObject topLevelPackage = this.eastadlRelease.getRootEFactory().create(topLevelPackageType);
            EList topLevelPackages = (EList)rootObject.eGet(topLevelPackagesFeature);
            topLevelPackages.add((Object)topLevelPackage);
            EStructuralFeature eastadlPackagesFeature = topLevelPackageType.getEStructuralFeature(EAPACKAGES_FEATURE_NAME);
            EList eastadlPackages = (EList)topLevelPackage.eGet(eastadlPackagesFeature);
            eastadlPackages.add((Object)eaPackage);
        }
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)this.eastadlFile.getProject(), (IMetaModelDescriptor)this.eastadlRelease);
        EcorePlatformUtil.saveNewModelResource((TransactionalEditingDomain)editingDomain, (IPath)this.eastadlFile.getFullPath(), (String)this.eastadlRelease.getDefaultContentTypeId(), (EObject)rootObject, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        return Status.OK_STATUS;
    }
}

