/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer;

import org.eclipse.eatop.examples.explorer.AppearanceAction;
import org.eclipse.eatop.examples.explorer.internal.Activator;
import org.eclipse.eatop.examples.explorer.internal.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class AppearanceExampleActionProvider
extends CommonActionProvider {
    static final String MODEL_ELEMENT_APPEARANCE_PROPERTY = "model_element_appearance_property";
    private boolean contributedToViewMenu = false;
    private IAction showNamesOnlyAction = null;
    private IAction showNamesAndTypesAction = null;
    CommonViewer viewer;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.viewer = (CommonViewer)aSite.getStructuredViewer();
        this.createActions();
        boolean showTypeName = true;
        if (Activator.getPlugin().getDialogSettings().get(MODEL_ELEMENT_APPEARANCE_PROPERTY) != null) {
            showTypeName = Activator.getPlugin().getDialogSettings().getBoolean(MODEL_ELEMENT_APPEARANCE_PROPERTY);
        }
        this.setShowTypeName(showTypeName);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.contributedToViewMenu) {
            try {
                super.fillActionBars(actionBars);
                this.contributeToViewMenu(actionBars.getMenuManager());
            }
            finally {
                this.contributedToViewMenu = true;
            }
        }
    }

    void setShowTypeName(boolean showTypeName) {
        this.showNamesOnlyAction.setChecked(!showTypeName);
        this.showNamesAndTypesAction.setChecked(showTypeName);
        Activator.getPlugin().getDialogSettings().put(MODEL_ELEMENT_APPEARANCE_PROPERTY, showTypeName);
    }

    private void createActions() {
        this.showNamesOnlyAction = new AppearanceAction(Messages.AppearanceAction_text_showName, this, false);
        this.showNamesAndTypesAction = new AppearanceAction(Messages.AppearanceAction_text_showNameAndType, this, true);
    }

    private void contributeToViewMenu(IMenuManager menuManager) {
        MenuManager topLevelSubMenu = new MenuManager(Messages.AppearanceMenutext);
        topLevelSubMenu.add((IContributionItem)new Separator());
        topLevelSubMenu.add(this.showNamesOnlyAction);
        topLevelSubMenu.add(this.showNamesAndTypesAction);
        menuManager.insertBefore("additions", (IContributionItem)topLevelSubMenu);
    }
}

