/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.AbstractCollationEqualFunction;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnIndexOf
extends AbstractCollationEqualFunction {
    private static Collection _expected_args = null;

    public FnIndexOf() {
        super(new QName("index-of"), 2, 3);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnIndexOf.index_of(args, this.dynamic_context());
    }

    private static CmpEq get_comparable(AnyType at) throws DynamicError {
        if (at instanceof NodeType) {
            XSString nodeString = new XSString(at.string_value());
            return nodeString;
        }
        if (!(at instanceof AnyAtomicType)) {
            DynamicError.throw_type_error();
        }
        if (!(at instanceof CmpEq)) {
            throw DynamicError.not_cmp(null);
        }
        return (CmpEq)((Object)at);
    }

    public static ResultSequence index_of(Collection args, DynamicContext dynamicContext) throws DynamicError {
        ResultSequence arg3;
        Function.convert_arguments(args, FnIndexOf.expected_args());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator citer = args.iterator();
        ResultSequence arg1 = (ResultSequence)citer.next();
        ResultSequence arg2 = (ResultSequence)citer.next();
        if (arg1.empty()) {
            return rs;
        }
        if (arg2.size() != 1) {
            DynamicError.throw_type_error();
        }
        String collationUri = dynamicContext.default_collation_name();
        if (citer.hasNext() && !(arg3 = (ResultSequence)citer.next()).empty()) {
            XSString collation = (XSString)arg3.first();
            collationUri = collation.string_value();
        }
        AnyAtomicType at = (AnyAtomicType)arg2.first();
        FnIndexOf.get_comparable(at);
        int index = 1;
        ListIterator i = arg1.iterator();
        while (i.hasNext()) {
            XSString itemStr;
            XSString xstr1;
            AnyType cmptype = (AnyType)i.next();
            FnIndexOf.get_comparable(cmptype);
            if (!(at instanceof CmpEq)) continue;
            if (FnIndexOf.isBoolean(cmptype, (AnyType)at)) {
                XSBoolean boolat = (XSBoolean)cmptype;
                if (boolat.eq(at, dynamicContext)) {
                    rs.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (FnIndexOf.isNumeric(cmptype, (AnyType)at)) {
                NumericType numericat = (NumericType)at;
                if (numericat.eq(cmptype, dynamicContext)) {
                    rs.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (FnIndexOf.isDuration(cmptype, (AnyType)at)) {
                XSDuration durat = (XSDuration)at;
                if (durat.eq(cmptype, dynamicContext)) {
                    rs.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (FnIndexOf.needsStringComparison(cmptype, (AnyType)at) && FnCompare.compare_string(collationUri, xstr1 = new XSString(cmptype.string_value()), itemStr = new XSString(at.string_value()), dynamicContext).equals(BigInteger.ZERO)) {
                rs.add(new XSInteger(BigInteger.valueOf(index)));
            }
            ++index;
        }
        return rs;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(AnyType.class, 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(AnyAtomicType.class, 0));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(arg);
        }
        return _expected_args;
    }
}

