/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSFUtils12
extends JSFUtils {
    protected JSFUtils12(IModelProvider modelProvider) {
        this(JSFVersion.V1_2, modelProvider);
    }

    protected JSFUtils12(JSFVersion jsfVersion, IModelProvider modelProvider) {
        super(jsfVersion, modelProvider);
        if (jsfVersion.compareTo(JSFVersion.V1_2) < 0) {
            throw new IllegalArgumentException("JsfVersion must be at least 1.2");
        }
    }

    private Servlet findJSFServlet(WebApp webApp) {
        if (webApp == null) {
            return null;
        }
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet == null || servlet.getServletClass() == null || !servlet.getServletClass().trim().equals("javax.faces.webapp.FacesServlet")) continue;
            return servlet;
        }
        return null;
    }

    @Override
    public void doVersionSpecificConfigFile(PrintWriter pw) {
        String QUOTE = new String(new char[]{'\"'});
        String schemaVersionString = this.getVersion().toString().replaceAll("\\.", "_");
        pw.write("<?xml version=" + QUOTE + "1.0" + QUOTE + " encoding=" + QUOTE + "UTF-8" + QUOTE + "?>\n\n");
        pw.write("<faces-config\n");
        pw.write("    xmlns=" + QUOTE + "http://java.sun.com/xml/ns/javaee" + QUOTE + "\n");
        pw.write("    xmlns:xsi=" + QUOTE + "http://www.w3.org/2001/XMLSchema-instance" + QUOTE + "\n");
        pw.write("    xsi:schemaLocation=" + QUOTE + String.format("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facesconfig_%s.xsd", schemaVersionString) + QUOTE + "\n");
        pw.write("    version=" + QUOTE + this.getVersion().toString() + QUOTE + ">\n\n");
        pw.write("</faces-config>\n");
    }

    private Servlet createOrUpdateServletRef(WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = this.getDisplayName(config);
        String className = this.getServletClassname(config);
        if (servlet == null) {
            servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            servlet.setServletClass(className);
            servlet.setLoadOnStartup((Object)1);
            webApp.getServlets().add(servlet);
        } else {
            this.updateServletMappings(webApp, servlet, displayName);
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup((Object)1);
        }
        return servlet;
    }

    private void updateServletMappings(WebApp webApp, Servlet servlet, String displayName) {
        ServletMapping mapping = this.findServletMapping(webApp, servlet);
        if (mapping != null) {
            mapping.setServletName(displayName);
        }
    }

    private void setUpURLMappings(WebApp webApp, List<String> urlMappingList, Servlet servlet) {
        if (urlMappingList.size() > 0) {
            ServletMapping mapping = this.findServletMapping(webApp, servlet);
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servlet.getServletName());
                webApp.getServletMappings().add(mapping);
            }
            for (String pattern : urlMappingList) {
                if (this.doesServletMappingPatternExist(webApp, servlet, pattern)) continue;
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(pattern);
                mapping.getUrlPatterns().add(urlPattern);
            }
        }
    }

    private ServletMapping findServletMapping(WebApp webApp, Servlet servlet) {
        for (ServletMapping mapping : webApp.getServletMappings()) {
            if (mapping.getServletName() == null || servlet.getServletName() == null || !mapping.getServletName().trim().equals(servlet.getServletName().trim())) continue;
            return mapping;
        }
        return null;
    }

    private boolean doesServletMappingPatternExist(WebApp webApp, Servlet servlet, String pattern) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            for (ServletMapping mapping : mappings) {
                if (mapping == null || mapping.getServletName() == null || !servletName.equals(mapping.getServletName().trim())) continue;
                for (UrlPatternType urlPattern : mapping.getUrlPatterns()) {
                    String patternTypeValue = urlPattern.getValue();
                    if (patternTypeValue == null || !pattern.equals(patternTypeValue.trim())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void removeURLMappings(WebApp webApp, Servlet servlet) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServletName() != null && mapping.getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    private void setupConfigFileContextParamForV2_5(WebApp webApp, IDataModel config) {
        ParamValue foundCP = null;
        ParamValue cp2 = null;
        boolean found = false;
        String stringProperty = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        if (stringProperty != null && !stringProperty.equals("/WEB-INF/faces-config.xml")) {
            for (ParamValue cp2 : webApp.getContextParams()) {
                if (cp2 == null || cp2.getParamName() == null || !cp2.getParamName().trim().equals("javax.faces.CONFIG_FILES")) continue;
                foundCP = cp2;
                found = true;
            }
            if (!found) {
                ParamValue pv = JavaeeFactory.eINSTANCE.createParamValue();
                pv.setParamName("javax.faces.CONFIG_FILES");
                pv.setParamValue(stringProperty);
                webApp.getContextParams().add(pv);
            } else {
                cp2 = foundCP;
                if (cp2.getParamValue().indexOf(stringProperty) < 0) {
                    String curVal = cp2.getParamValue();
                    String val = stringProperty;
                    if (curVal != null && !"".equals(curVal.trim())) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp2.setParamValue(val);
                }
            }
        }
    }

    private String getDefaultSuffix(WebApp webApp) {
        String defaultSuffix = this.getDefaultDefaultSuffix();
        for (ParamValue cp : webApp.getContextParams()) {
            String paramName;
            String suffix;
            if (cp == null || (suffix = this.calculateSuffix(paramName = cp.getParamName(), cp.getParamValue())) == null) continue;
            return suffix;
        }
        return defaultSuffix;
    }

    private String getPrefixMapping(ServletMapping map) {
        List urls = map.getUrlPatterns();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            Path extPath = new Path(((UrlPatternType)it.next()).getValue());
            String ext = extPath.getFileExtension();
            if (ext != null) continue;
            String lastSeg = extPath.lastSegment();
            if (lastSeg.equals("*")) {
                return extPath.removeLastSegments(1).toString();
            }
            return extPath.toString();
        }
        return null;
    }

    private String getFileExtensionFromMap(ServletMapping map) {
        List urls = map.getUrlPatterns();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            Path extPath = new Path(((UrlPatternType)it.next()).getValue());
            String ext = extPath.getFileExtension();
            if (ext == null || ext.equals("")) continue;
            return ext;
        }
        return null;
    }

    @Override
    public void updateWebApp(Object webApp, IDataModel config) {
        Servlet servlet = this.findJSFServlet((WebApp)webApp);
        servlet = this.createOrUpdateServletRef((WebApp)webApp, config, servlet);
        List<String> listOfMappings = this.getServletMappings(config);
        this.setUpURLMappings((WebApp)webApp, listOfMappings, servlet);
        this.setupConfigFileContextParamForV2_5((WebApp)webApp, config);
    }

    @Override
    public void rollbackWebApp(Object webApp) {
        Servlet servlet = this.findJSFServlet((WebApp)webApp);
        if (servlet == null) {
            return;
        }
        this.removeURLMappings((WebApp)webApp, servlet);
        this.removeJSFContextParams((WebApp)webApp, servlet);
        this.removeJSFServlet((WebApp)webApp, servlet);
    }

    private void removeJSFContextParams(WebApp webApp, Servlet servlet) {
        for (ParamValue cp : webApp.getContextParams()) {
            if (!cp.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
            webApp.getContextParams().remove(cp);
            break;
        }
    }

    private void removeJSFServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove(servlet);
    }

    @Override
    public IPath getFileUrlPath(Object webAppObj, IResource resource, IPath existingURL) {
        if (webAppObj instanceof WebApp) {
            boolean canUseExtensionMapping;
            WebApp webApp = (WebApp)webAppObj;
            Servlet servlet = this.findJSFServlet(webApp);
            if (servlet == null) {
                return null;
            }
            String servletName = servlet.getServletName();
            if (!this.isJSFPage(resource)) {
                return null;
            }
            String defaultSuffix = this.getDefaultSuffix(webApp);
            String fileExtension = resource.getFileExtension();
            boolean bl = canUseExtensionMapping = fileExtension != null && fileExtension.equalsIgnoreCase(defaultSuffix);
            if (!canUseExtensionMapping && !this.isValidKnownExtension(resource.getFileExtension())) {
                return null;
            }
            String foundFileExtension = null;
            for (ServletMapping map : webApp.getServletMappings()) {
                if (map == null || map.getServletName() == null || !map.getServletName().trim().equals(servletName.trim())) continue;
                foundFileExtension = this.getFileExtensionFromMap(map);
                if (foundFileExtension != null && canUseExtensionMapping) {
                    return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
                }
                String foundPrefixMapping = this.getPrefixMapping(map);
                if (foundPrefixMapping == null) continue;
                return new Path(foundPrefixMapping).append(existingURL);
            }
            if (!canUseExtensionMapping && foundFileExtension != null) {
                return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
            }
        }
        return null;
    }
}

