/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterUpdater;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSetParametersUpdater {
    static final String BIRT_JS_EXPR = "JS_EXPR";
    private List<OdaDataSetParameterHandle> toUpdateParams = null;
    private List<OdaDataSetParameterHandle> setDefinedParams = null;
    private List<OdaDataSetParameter> newParams = null;
    private String dataSourceId = null;
    private String dataSetId = null;
    private OdaDataSetHandle setHandle = null;

    DataSetParametersUpdater(DataSetDesign setDesign, OdaDataSetHandle setHandle, List<OdaDataSetParameter> updateParams) {
        this.setHandle = setHandle;
        Iterator tmpParams = setHandle.parametersIterator();
        this.setDefinedParams = new ArrayList<OdaDataSetParameterHandle>();
        while (tmpParams.hasNext()) {
            this.setDefinedParams.add((OdaDataSetParameterHandle)tmpParams.next());
        }
        this.dataSourceId = setDesign.getOdaExtensionDataSourceId();
        this.dataSetId = setDesign.getOdaExtensionDataSetId();
        this.toUpdateParams = this.buildUpdateParams(updateParams);
    }

    private List<OdaDataSetParameterHandle> buildUpdateParams(List<OdaDataSetParameter> updateParams) {
        if (updateParams == null) {
            return Collections.emptyList();
        }
        ArrayList<OdaDataSetParameterHandle> retList = new ArrayList<OdaDataSetParameterHandle>();
        int i = 0;
        while (i < updateParams.size()) {
            OdaDataSetParameter param = updateParams.get(i);
            int j = 0;
            while (j < this.setDefinedParams.size()) {
                OdaDataSetParameterHandle paramHandle = this.setDefinedParams.get(j);
                if (paramHandle.getStructure() == param && !retList.contains(paramHandle)) {
                    retList.add(paramHandle);
                }
                ++j;
            }
            ++i;
        }
        return retList;
    }

    public void processDataSetParameters(DataSetParameters params) throws SemanticException {
        if (params == null) {
            return;
        }
        if (this.newParams == null) {
            this.newParams = new ArrayList<OdaDataSetParameter>();
        }
        EList tmpParams = params.getParameterDefinitions();
        OdaDataSetParameterHandle foundParam = null;
        OdaDataSetParameterHandle oldSetParam = null;
        OdaDataSetParameter newParam = null;
        int i = 0;
        while (i < tmpParams.size()) {
            block8: {
                ParameterDefinition paramDefn;
                block7: {
                    block5: {
                        block6: {
                            paramDefn = (ParameterDefinition)tmpParams.get(i);
                            DataElementAttributes dataAttrs = paramDefn.getAttributes();
                            foundParam = this.findDataSetParameterByName(dataAttrs.getName(), dataAttrs.getPosition(), dataAttrs.getNativeDataTypeCode(), this.toUpdateParams.iterator());
                            if (foundParam == null) {
                                oldSetParam = this.findDataSetParameterByName(dataAttrs.getName(), dataAttrs.getPosition(), dataAttrs.getNativeDataTypeCode(), this.setDefinedParams.iterator());
                            }
                            if (foundParam != null) break block5;
                            if (oldSetParam != null) break block6;
                            newParam = StructureFactory.createOdaDataSetParameter();
                            break block7;
                        }
                        this.newParams.add((OdaDataSetParameter)oldSetParam.getStructure().copy());
                        break block8;
                    }
                    newParam = (OdaDataSetParameter)foundParam.getStructure().copy();
                }
                this.newParams.add(newParam);
                DataSetParameterUpdater oneUpdater = new DataSetParameterUpdater(newParam, paramDefn, this.setHandle, this.dataSourceId, this.dataSetId, this.setDefinedParams);
                oneUpdater.process();
            }
            ++i;
        }
        PropertyHandle propHandle = this.setHandle.getPropertyHandle("parameters");
        propHandle.clearValue();
        int i2 = 0;
        while (i2 < this.newParams.size()) {
            propHandle.addItem((IStructure)this.newParams.get(i2));
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private OdaDataSetParameterHandle findDataSetParameterByName(String dataSetParamName, Integer position, Integer nativeDataType, Iterator params) {
        if (position != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            param = (OdaDataSetParameterHandle)params.next();
            tmpNativeDataType = param.getNativeDataType();
            tmpNativeName = param.getNativeName();
            if (!StringUtil.isBlank((String)tmpNativeName) && tmpNativeName.equals(dataSetParamName)) {
                return param;
            }
            if (!StringUtil.isBlank((String)tmpNativeName) || !position.equals(param.getPosition()) || tmpNativeDataType != null && !tmpNativeDataType.equals(nativeDataType)) continue;
            return param;
lbl10:
            // 2 sources

            ** while (params.hasNext())
        }
lbl11:
        // 1 sources

        return null;
    }
}

