/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.model.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.DocumentRoot;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.model.Serializer;
import org.eclipse.birt.report.model.adapter.oda.model.util.ModelResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class SerializerImpl
implements Serializer {
    private static Serializer sz = null;

    static {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/birt/report/model/adapter/odaModel", (Object)ModelFactory.eINSTANCE);
    }

    private SerializerImpl() {
    }

    public static final synchronized Serializer instance() {
        if (sz == null) {
            sz = new SerializerImpl();
        }
        return sz;
    }

    public void write(DesignValues cModel, OutputStream os) throws IOException {
        ResourceSetImpl rsOdaValues = new ResourceSetImpl();
        rsOdaValues.getResourceFactoryRegistry().getExtensionToFactoryMap().put("designValues", new ModelResourceFactoryImpl());
        Resource rOdaValue = rsOdaValues.createResource(URI.createFileURI((String)"test.designValues"));
        cModel.setVersion("1.0");
        rOdaValue.getContents().add((Object)cModel);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rOdaValue.save(os, options);
    }

    public DesignValues read(InputStream is) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("designValue", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.designValue"));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.load(is, options);
        DocumentRoot docRoot = (DocumentRoot)rChart.getContents().get(0);
        return docRoot.getDesignValues();
    }

    public DesignValues read(String values) throws IOException {
        if (values == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(values.getBytes("utf-8"));
        DesignValues retValues = this.read(bis);
        bis.close();
        return retValues;
    }

    public String write(DesignValues values) throws IOException {
        if (values == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.write(values, bos);
        String retValue = bos.toString("utf-8");
        bos.close();
        return retValue;
    }
}

