/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.util.LinkedList;
import java.util.ListIterator;

class ContentTreeCache {
    LinkedList entries = new LinkedList();

    ContentTreeCache() {
    }

    public void addEntry(TreeEntry entry) {
        ListIterator<TreeEntry> iter = this.entries.listIterator(this.entries.size());
        while (iter.hasPrevious()) {
            TreeEntry treeEntry = (TreeEntry)iter.previous();
            if (treeEntry.offset >= entry.offset) continue;
            if (treeEntry.next == entry.offset) {
                entry.previous = treeEntry.offset;
            }
            while (treeEntry.offset != entry.parent) {
                iter.remove();
                if (!iter.hasPrevious()) break;
                treeEntry = (TreeEntry)iter.previous();
            }
            if (!iter.hasNext()) break;
            iter.next();
            break;
        }
        iter.add(entry);
    }

    public TreeEntry getEntry(long offset) {
        ListIterator iter = this.entries.listIterator(this.entries.size());
        while (iter.hasPrevious()) {
            TreeEntry entry = (TreeEntry)iter.previous();
            if (entry.offset == offset) {
                return entry;
            }
            if (entry.offset < offset) break;
        }
        return null;
    }

    static class TreeEntry {
        long offset;
        long parent;
        long next;
        long previous;
        Object value;

        public TreeEntry(long offset, long parent, long next, Object value) {
            this.offset = offset;
            this.parent = parent;
            this.next = next;
            this.previous = -1L;
            this.value = value;
        }
    }
}

