/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;

public class HTMLTableLM
extends HTMLBlockStackingLM {
    protected HTMLTableLayoutEmitter tableEmitter;
    boolean isFirstLayout = true;
    boolean isHeaderRefined = false;

    public HTMLTableLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 3;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        this.tableEmitter = new HTMLTableLayoutEmitter(emitter, this.context);
        super.initialize(parent, content, executor, this.tableEmitter);
        this.isFirstLayout = true;
        this.isHeaderRefined = false;
    }

    protected void repeatHeader() throws BirtException {
        ITableBandContent header;
        ITableContent table;
        if (!this.isFirstLayout && (table = (ITableContent)this.content).isHeaderRepeat() && (header = table.getHeader()) != null) {
            this.refineBandContent(header);
            this.cleanRepeatedLayoutExtension(header);
            boolean pageBreak = this.context.allowPageBreak();
            this.context.setAllowPageBreak(false);
            IPageBuffer buffer = this.context.getPageBufferManager();
            boolean isRepeated = buffer.isRepeated();
            buffer.setRepeated(true);
            this.engine.layout((ILayoutManager)this, header, this.emitter);
            buffer.setRepeated(isRepeated);
            this.context.setAllowPageBreak(pageBreak);
        }
        this.isFirstLayout = false;
    }

    private void refineBandContent(ITableBandContent content) {
        if (this.isHeaderRefined) {
            return;
        }
        Collection children = content.getChildren();
        ArrayList<IRowContent> removed = new ArrayList<IRowContent>();
        if (children != null) {
            for (IRowContent rowContent : children) {
                RowDesign rowDesign = (RowDesign)rowContent.getGenerateBy();
                if (rowDesign == null || rowDesign.getRepeatable()) continue;
                removed.add(rowContent);
            }
            children.removeAll(removed);
        }
        this.isHeaderRefined = true;
    }

    private void cleanRepeatedLayoutExtension(IContent content) {
        Collection children = content.getChildren();
        if (children == null) {
            return;
        }
        for (IContent child : children) {
            child.setExtension(1, null);
            this.cleanRepeatedLayoutExtension(child);
        }
    }

    protected boolean layoutChildren() throws BirtException {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        return hasNext;
    }

    protected void end(boolean finished) throws BirtException {
        this.context.getPageBufferManager().endContainer(this.content, finished, this.tableEmitter, true);
    }

    protected void start(boolean isFirst) throws BirtException {
        this.context.getPageBufferManager().startContainer(this.content, isFirst, this.tableEmitter, true);
    }

    protected IContentEmitter getEmitter() {
        return this.tableEmitter;
    }
}

