/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableHeaderContextContainmentValidator
extends AbstractElementValidator {
    private static final TableHeaderContextContainmentValidator instance = new TableHeaderContextContainmentValidator();

    public static TableHeaderContextContainmentValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof ListingElement)) {
            return Collections.emptyList();
        }
        return this.doValidate(module, new ContainerContext(element, -1));
    }

    private List<SemanticException> doValidate(Module module, ContainerContext containerInfo) {
        assert (containerInfo != null);
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        ContainerContext infor = containerInfo;
        if (containerInfo.getSlotID() == -1) {
            infor = containerInfo.getElement().getContainerInfo();
        }
        while (infor != null) {
            IElementDefn containerDefn = infor.getElement().getDefn();
            if ("Table".equalsIgnoreCase(containerDefn.getName()) && infor.getSlotID() == 0) {
                list.add(new ContentException(infor.getElement(), infor.getSlotID(), containerInfo.getElement(), "Error.ContentException.INVALID_CONTEXT_CONTAINMENT"));
            }
            infor = infor.getElement().getContainerInfo();
        }
        return list;
    }

    public List<SemanticException> validateForAdding(Module module, ContainerContext containerInfo, DesignElement toAdd) {
        if (!(toAdd instanceof ListingElement) && !ModelUtil.containElement(module, toAdd, "Listing")) {
            return Collections.emptyList();
        }
        return this.doValidate(module, containerInfo);
    }

    public List<SemanticException> validateForAdding(Module module, DesignElement element, int slotId, DesignElement toAdd) {
        if (!(toAdd instanceof ListingElement) && !ModelUtil.containElement(module, toAdd, "Listing")) {
            return Collections.emptyList();
        }
        return this.doValidate(module, new ContainerContext(element, slotId));
    }

    public List<SemanticException> validateForAdding(Module module, DesignElement element, IElementDefn toAdd) {
        ElementDefn listingDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("Listing");
        if (!toAdd.isKindOf(listingDefn)) {
            return Collections.emptyList();
        }
        return this.doValidate(module, new ContainerContext(element, -1));
    }
}

