/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.dstore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class RemoteFilePropertyChangeListener
implements IDomainListener,
ICommunicationsListener {
    protected DataStore dataStore;
    protected FileServiceSubSystem _fileSubSystem;
    protected Shell shell;
    protected ISystemRegistry _registry;
    protected IConnectorService system;
    protected boolean _networkDown = false;
    protected HashMap _decorateJobs;
    protected boolean _finished = false;

    public RemoteFilePropertyChangeListener(Shell shell, IConnectorService system, DataStore dataStore, FileServiceSubSystem fileSS) {
        this.shell = shell;
        this._fileSubSystem = fileSS;
        this.dataStore = dataStore;
        this.system = system;
        this._registry = RSECorePlugin.getTheSystemRegistry();
        system.addCommunicationsListener((ICommunicationsListener)this);
        dataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
        this._decorateJobs = new HashMap();
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public boolean listeningTo(DomainEvent event) {
        DataElement parent = (DataElement)event.getParent();
        if (this.dataStore == parent.getDataStore()) {
            String dataElementType = parent.getType();
            return dataElementType != null && (dataElementType.equals("universal.FolderObject") || dataElementType.equals("universal.FileObject"));
        }
        return false;
    }

    public void finish() {
        this.dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this);
        this._finished = true;
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void domainChanged(DomainEvent event) {
        DataElement parent = (DataElement)event.getParent();
        List children = parent.getNestedData();
        if (children != null) {
            DecorateJob job;
            StringBuffer parentPath = new StringBuffer(parent.getAttribute(3));
            parentPath.append(this._fileSubSystem.getSeparatorChar());
            parentPath.append(parent.getName());
            DStoreFile parentFile = (DStoreFile)this._fileSubSystem.getCachedRemoteFile(parentPath.toString());
            ArrayList<DataElement> toUpdate = new ArrayList<DataElement>();
            int i = 0;
            while (i < children.size()) {
                DataElement subject = (DataElement)children.get(i);
                String type = subject.getType();
                if (type != null && (type.equals("universal.FileObject") || type.equals("universal.FolderObject"))) {
                    toUpdate.add(subject);
                }
                ++i;
            }
            if (!toUpdate.isEmpty() && (job = this.getDecorateJob((IRemoteFile)parentFile)) == null) {
                job = new DecorateJob(toUpdate.toArray(new DataElement[toUpdate.size()]), parentFile);
                job.setRule((ISchedulingRule)parentFile);
                this.putDecorateJob((IRemoteFile)parentFile, job);
                job.schedule(1000L);
            }
        }
    }

    protected DecorateJob getDecorateJob(IRemoteFile file) {
        return (DecorateJob)((Object)this._decorateJobs.get(file));
    }

    protected void putDecorateJob(IRemoteFile file, DecorateJob job) {
        this._decorateJobs.put(file, job);
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        if (e.getState() == 5) {
            this._networkDown = true;
        } else if (e.getState() == 3) {
            this.finish();
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public class DecorateJob
    extends UIJob {
        private DataElement[] _files;
        private DStoreFile _parentFile;
        private boolean _isDone = false;

        public DecorateJob(DataElement[] files, DStoreFile parentFile) {
            super(SystemFileResources.RESID_JOB_DECORATEFILES_NAME);
            this._files = files;
            this._parentFile = parentFile;
        }

        public boolean isDone() {
            return this._isDone;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this._isDone = false;
            Object[] children = new IRemoteFile[this._files.length];
            try {
                int i = 0;
                while (i < this._files.length) {
                    DataElement file = this._files[i];
                    StringBuffer path = new StringBuffer(file.getAttribute(3));
                    path.append(RemoteFilePropertyChangeListener.this._fileSubSystem.getSeparatorChar());
                    path.append(file.getName());
                    children[i] = RemoteFilePropertyChangeListener.this._fileSubSystem.getRemoteFileObject(path.toString(), monitor);
                    ++i;
                }
                RemoteFilePropertyChangeListener.this._registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(children, 81, (Object)this._parentFile));
            }
            catch (Exception exception) {}
            this._isDone = true;
            RemoteFilePropertyChangeListener.this._decorateJobs.remove((Object)this._parentFile);
            return Status.OK_STATUS;
        }
    }
}

