/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ReportRootFigure
extends ReportElementFigure {
    private static final Insets DEFAULT_MARGIN = new Insets(3, 3, 3, 3);
    private static final Point PRIVATE_POINT = new Point();
    public static final Insets DEFAULT_CROP = new Insets(-3, -3, -2, -2);
    private boolean showMargin;

    public Insets getInsets() {
        if (this.showMargin) {
            if (this.getBorder() != null) {
                return this.getBorder().getInsets((IFigure)this);
            }
            return NO_INSETS;
        }
        return DEFAULT_MARGIN;
    }

    protected void paintFigure(Graphics graphics) {
        graphics.fillRectangle(this.getBounds());
        super.paintFigure(graphics);
        graphics.setForegroundColor(ReportColorConstants.ReportForeground);
        graphics.drawRectangle(this.getBounds().getCopy().crop(new Insets(0, 0, 1, 1)));
    }

    protected void paintChildren(Graphics graphics) {
        int i = 0;
        while (i < this.getChildren().size()) {
            Rectangle clip = graphics.getClip(Rectangle.SINGLETON);
            IFigure child = (IFigure)this.getChildren().get(i);
            if (child.isVisible()) {
                Rectangle bounds = child.getBounds().getCopy();
                int extend = bounds.x + bounds.width - clip.x - clip.width;
                if (extend > 0) {
                    clip.width += extend;
                }
                if (child.intersects(clip)) {
                    graphics.setClip(clip.getCopy());
                    graphics.clipRect(bounds);
                    child.paint(graphics);
                    graphics.restoreState();
                }
            }
            ++i;
        }
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent((Translatable)PRIVATE_POINT);
        if (!this.getBounds().contains(PRIVATE_POINT)) {
            return null;
        }
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || (fig = fig.findFigureAt(ReportRootFigure.PRIVATE_POINT.x, ReportRootFigure.PRIVATE_POINT.y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    public boolean isShowMargin() {
        return this.showMargin;
    }

    public void setShowMargin(boolean showMargin) {
        this.showMargin = showMargin;
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent((Translatable)PRIVATE_POINT);
        if (!this.getBounds().contains(PRIVATE_POINT)) {
            return null;
        }
        List children = this.getChildren();
        int i = children.size();
        while (i > 0) {
            IFigure fig;
            if (!(fig = (IFigure)children.get(--i)).isVisible() || !fig.isEnabled() || !fig.containsPoint(ReportRootFigure.PRIVATE_POINT.x, ReportRootFigure.PRIVATE_POINT.y)) continue;
            fig = fig.findMouseEventTargetAt(ReportRootFigure.PRIVATE_POINT.x, ReportRootFigure.PRIVATE_POINT.y);
            return fig;
        }
        return null;
    }
}

