/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class TableFigure
extends FreeformViewport
implements IReportElementFigure {
    private static final String BORDER_TEXT = Messages.getString((String)"TableFigure.BORDER_TEXT");
    private Image img;
    private int alignment;
    private Point position = new Point(-1, -1);
    private int repeat;
    private Insets margin = new Insets();
    private Dimension size = new Dimension();

    public TableFigure() {
        TableBorder border = new TableBorder();
        border.setIndicatorLabel(BORDER_TEXT);
        border.setIndicatorIcon(ReportPlatformUIImages.getImage("Table"));
        this.setBorder((Border)border);
        this.setLayoutManager((LayoutManager)new TableViewportLayout());
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        this.getContents().invalidate();
        return ((LayeredPane)((LayeredPane)this.getContents()).getLayer((Object)"Printable Layers")).getLayer((Object)"Primary Layer").getMinimumSize(wHint, hHint);
    }

    protected void paintBorder(Graphics graphics) {
    }

    protected void paintFigure(Graphics graphics) {
        int y;
        int x;
        Image image;
        if (this.isOpaque()) {
            if (this.getBorder() instanceof BaseBorder) {
                graphics.fillRectangle(this.getBounds().getCopy().crop(((BaseBorder)this.getBorder()).getBorderInsets()));
            } else {
                graphics.fillRectangle(this.getBounds());
            }
        }
        if ((image = this.getImage()) == null) {
            return;
        }
        Rectangle area = this.getBounds();
        if (this.position != null && this.position.x != -1) {
            x = area.x + this.position.x;
        } else {
            switch (this.alignment & 0x18) {
                case 16: {
                    x = area.x + area.width - this.size.width;
                    break;
                }
                case 8: {
                    x = area.x;
                    break;
                }
                default: {
                    x = (area.width - this.size.width) / 2 + area.x;
                }
            }
        }
        if (this.position != null && this.position.y != -1) {
            y = area.y + this.position.y;
        } else {
            switch (this.alignment & 5) {
                case 1: {
                    y = area.y;
                    break;
                }
                case 4: {
                    y = area.y + area.height - this.size.height;
                    break;
                }
                default: {
                    y = (area.height - this.size.height) / 2 + area.y;
                }
            }
        }
        ArrayList xyList = this.createImageList(x, y);
        for (Point point : xyList) {
            graphics.drawImage(image, point);
        }
        xyList.clear();
    }

    private ArrayList createImageList(int x, int y) {
        Rectangle area = this.getBounds();
        ArrayList<Point> yList = new ArrayList<Point>();
        if ((this.repeat & 2) == 0) {
            yList.add(new Point(x, y));
        } else {
            int i = 0;
            while (y + this.size.height * i + this.size.height > area.y) {
                yList.add(new Point(x, y + this.size.height * i));
                --i;
            }
            i = 1;
            while (y + this.size.height * i < area.y + area.height) {
                yList.add(new Point(x, y + this.size.height * i));
                ++i;
            }
        }
        ArrayList<Point> xyList = new ArrayList<Point>();
        for (Point point : yList) {
            if ((this.repeat & 1) == 0) {
                xyList.add(point);
                continue;
            }
            int i = 0;
            while (point.x + this.size.width * i + this.size.width > area.x) {
                xyList.add(new Point(point.x + this.size.width * i, point.y));
                --i;
            }
            i = 1;
            while (point.x + this.size.width * i < area.x + area.width) {
                xyList.add(new Point(point.x + this.size.width * i, point.y));
                ++i;
            }
        }
        yList.clear();
        return xyList;
    }

    public Image getImage() {
        return this.img;
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setPosition(Point point) {
        this.position = point;
    }

    public void setRepeat(int flag) {
        this.repeat = flag;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets newMargin) {
        if (newMargin == null) {
            this.margin = new Insets();
        } else {
            this.margin = new Insets(newMargin);
            if (this.margin.left < 0) {
                this.margin.left = 0;
            }
            if (this.margin.right < 0) {
                this.margin.right = 0;
            }
            if (this.margin.top < 0) {
                this.margin.top = 0;
            }
            if (this.margin.bottom < 0) {
                this.margin.bottom = 0;
            }
        }
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.size = this.img != null ? new Rectangle(image.getBounds()).getSize() : new Dimension();
        this.revalidate();
        this.repaint();
    }

    class TableViewportLayout
    extends ViewportLayout {
        TableViewportLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            TableFigure.this.getContents().invalidateTree();
            return ((FreeformFigure)TableFigure.this.getContents()).getFreeformExtent().getExpanded(TableFigure.this.getInsets()).union(0, 0).getSize();
        }

        protected boolean isSensitiveHorizontally(IFigure parent) {
            return true;
        }

        protected boolean isSensitiveVertically(IFigure parent) {
            return true;
        }

        public void layout(IFigure figure) {
        }
    }
}

