/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;
import org.eclipse.birt.core.btree.ValueEntry;
import org.eclipse.birt.core.btree.ValueNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalValueList<K, V>
implements BTreeValues<V> {
    private BTree<K, V> btree;
    private int valueCount;
    private int firstNodeId;
    private int lastNodeId;

    public ExternalValueList(BTree<K, V> btree) {
        this.btree = btree;
        this.valueCount = 0;
        this.firstNodeId = -1;
        this.lastNodeId = -1;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getValueSize() {
        return 12;
    }

    public int getFirstNodeId() {
        return this.firstNodeId;
    }

    public int getLastNodeId() {
        return this.lastNodeId;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.valueCount = input.readInt();
        this.firstNodeId = input.readInt();
        this.lastNodeId = input.readInt();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.valueCount);
        output.writeInt(this.firstNodeId);
        output.writeInt(this.lastNodeId);
    }

    @Override
    public BTreeValues.Value<V> getFirstValue() throws IOException {
        if (this.firstNodeId != -1) {
            ValueNode<K, V> valueNode = this.btree.loadValueNode(this.firstNodeId);
            try {
                ValueEntry<V> entry = valueNode.getFirstEntry();
                ExternalValue externalValue = new ExternalValue(valueNode, entry);
                return externalValue;
            }
            finally {
                valueNode.unlock();
            }
        }
        return null;
    }

    @Override
    public BTreeValues.Value<V> getLastValue() throws IOException {
        if (this.lastNodeId != -1) {
            ValueNode<K, V> valueNode = this.btree.loadValueNode(this.lastNodeId);
            try {
                ValueEntry<V> entry = valueNode.getLastEntry();
                ExternalValue externalValue = new ExternalValue(valueNode, entry);
                return externalValue;
            }
            finally {
                valueNode.unlock();
            }
        }
        return null;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public BTreeValues.Value<V> append(BTreeValue<V> value) throws IOException {
        if (this.lastNodeId == -1) {
            ValueNode<K, V> valueNode = this.btree.createValueNode();
            try {
                this.firstNodeId = valueNode.getNodeId();
                this.lastNodeId = valueNode.getNodeId();
                ValueEntry<V> entry = valueNode.append(value);
                ++this.valueCount;
                ExternalValue externalValue = new ExternalValue(valueNode, entry);
                return externalValue;
            }
            finally {
                valueNode.unlock();
            }
        }
        ValueNode<K, V> lastNode = this.btree.loadValueNode(this.lastNodeId);
        try {
            ExternalValue externalValue;
            int valueSize = this.btree.getValueSize(value);
            int nodeSize = lastNode.getNodeSize();
            if (nodeSize + valueSize <= 4092) {
                ValueEntry<V> entry = lastNode.append(value);
                ++this.valueCount;
                ExternalValue externalValue2 = new ExternalValue(lastNode, entry);
                return externalValue2;
            }
            ValueNode<K, V> valueNode = this.btree.createValueNode();
            try {
                ValueEntry<V> entry = valueNode.append(value);
                valueNode.setPrevNodeId(lastNode.getNodeId());
                lastNode.setNextNodeId(valueNode.getNodeId());
                lastNode.setDirty(true);
                this.lastNodeId = valueNode.getNodeId();
                ++this.valueCount;
                externalValue = new ExternalValue(valueNode, entry);
            }
            catch (Throwable throwable) {
                valueNode.unlock();
                throw throwable;
            }
            valueNode.unlock();
            return externalValue;
        }
        finally {
            lastNode.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExternalValue
    implements BTreeValues.Value<V> {
        ValueNode<K, V> node;
        ValueEntry<V> entry;

        ExternalValue(ValueNode<K, V> node, ValueEntry<V> entry) {
            this.node = node;
            this.entry = entry;
        }

        @Override
        public BTreeValues.Value<V> getPrev() throws IOException {
            ValueEntry prev = this.entry.getPrev();
            if (prev != null) {
                return new ExternalValue(this.node, prev);
            }
            int prevNodeId = this.node.getPrevNodeId();
            if (prevNodeId != -1) {
                ValueNode prevNode = ExternalValueList.this.btree.loadValueNode(prevNodeId);
                try {
                    prev = prevNode.getLastEntry();
                    if (prev != null) {
                        ExternalValue externalValue = new ExternalValue(prevNode, prev);
                        return externalValue;
                    }
                }
                finally {
                    prevNode.unlock();
                }
            }
            return null;
        }

        @Override
        public BTreeValues.Value<V> getNext() throws IOException {
            ValueEntry next = this.entry.getNext();
            if (next != null) {
                return new ExternalValue(this.node, next);
            }
            int nextNodeId = this.node.getNextNodeId();
            if (nextNodeId != -1) {
                ValueNode nextNode = ExternalValueList.this.btree.loadValueNode(nextNodeId);
                try {
                    next = nextNode.getFirstEntry();
                    if (next != null) {
                        ExternalValue externalValue = new ExternalValue(nextNode, next);
                        return externalValue;
                    }
                }
                finally {
                    nextNode.unlock();
                }
            }
            return null;
        }

        @Override
        public BTreeValue<V> getValue() {
            return this.entry.getValue();
        }
    }
}

