/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.synchronizers;

import java.util.Vector;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.internal.CompositeException;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.SynchronizedObject;
import org.eclipse.jpt.utility.internal.synchronizers.Synchronizer;

public class SynchronousSynchronizer
implements Synchronizer {
    private final Command command;
    final SynchronizedObject<State> state;
    final Vector<Throwable> exceptions = new Vector();

    public SynchronousSynchronizer(Command command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command;
        this.state = new SynchronizedObject<State>(State.STOPPED, this);
    }

    public synchronized void start() {
        switch (this.state.getValue()) {
            case STOPPED: {
                this.state.setValue(State.READY);
                this.synchronize();
                break;
            }
            default: {
                throw this.buildIllegalStateException();
            }
        }
    }

    public void synchronize() {
        if (this.beginSynchronization()) {
            this.synchronize_();
        }
    }

    private synchronized boolean beginSynchronization() {
        switch (this.state.getValue()) {
            case STOPPED: {
                return false;
            }
            case READY: {
                this.state.setValue(State.EXECUTING);
                return true;
            }
            case EXECUTING: {
                this.state.setValue(State.REPEAT);
                return false;
            }
            case REPEAT: {
                return false;
            }
            case STOPPING: {
                return false;
            }
        }
        throw this.buildIllegalStateException();
    }

    private void synchronize_() {
        do {
            this.execute();
        } while (this.endSynchronization());
    }

    private void execute() {
        try {
            this.execute_();
        }
        catch (Throwable ex) {
            this.exceptions.add(ex);
        }
    }

    void execute_() {
        this.command.execute();
    }

    private synchronized boolean endSynchronization() {
        switch (this.state.getValue()) {
            case STOPPED: 
            case READY: {
                throw this.buildIllegalStateException();
            }
            case EXECUTING: {
                this.state.setValue(State.READY);
                return false;
            }
            case REPEAT: {
                this.state.setValue(State.EXECUTING);
                return true;
            }
            case STOPPING: {
                this.state.setValue(State.STOPPED);
                return false;
            }
        }
        throw this.buildIllegalStateException();
    }

    public synchronized void stop() {
        switch (this.state.getValue()) {
            case STOPPED: {
                throw this.buildIllegalStateException();
            }
            case READY: {
                this.state.setValue(State.STOPPED);
                break;
            }
            case EXECUTING: 
            case REPEAT: {
                this.state.setValue(State.STOPPING);
                this.waitUntilStopped();
                break;
            }
            case STOPPING: {
                throw this.buildIllegalStateException();
            }
            default: {
                throw this.buildIllegalStateException();
            }
        }
        if (this.exceptions.size() > 0) {
            Throwable[] temp = this.exceptions.toArray(new Throwable[this.exceptions.size()]);
            this.exceptions.clear();
            throw new CompositeException(temp);
        }
    }

    private void waitUntilStopped() {
        try {
            this.state.waitUntilValueIs(State.STOPPED);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IllegalStateException buildIllegalStateException() {
        return new IllegalStateException("state: " + this.state);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        STOPPED,
        READY,
        EXECUTING,
        REPEAT,
        STOPPING;

    }
}

