/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.BooleanValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.NullValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.NumberValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.StringValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.UndefinedValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventQueue;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequestManager;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.BooleanValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.NullValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.NumberValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ScriptReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.StringValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ThreadReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.UndefinedValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.EventQueueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestManagerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TimeoutException;

public class VirtualMachineImpl
extends MirrorImpl
implements VirtualMachine {
    public final UndefinedValueImpl undefinedValue = new UndefinedValueImpl(this);
    public final NullValueImpl nullValue = new NullValueImpl(this);
    private final Map scripts = new HashMap();
    private final DebugSession session;
    private EventRequestManagerImpl eventRequestManager = new EventRequestManagerImpl(this);
    private final EventQueue eventQueue = new EventQueueImpl(this, this.eventRequestManager);
    private Map threads = new HashMap();
    private boolean disconnected = false;

    public VirtualMachineImpl(DebugSession debugSession) {
        super(" ");
        this.session = debugSession;
        this.initalizeScripts();
    }

    private void initalizeScripts() {
        Request request = new Request("scripts");
        try {
            Response response = this.sendRequest(request);
            List scriptIds = (List)response.getBody().get("scripts");
            Iterator iterator = scriptIds.iterator();
            while (iterator.hasNext()) {
                Long scriptId = new Long(((Number)iterator.next()).longValue());
                ScriptReferenceImpl script = this.createScriptReference(scriptId);
                if (script == null) continue;
                this.scripts.put(scriptId, script);
            }
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
    }

    private ScriptReferenceImpl createScriptReference(Long scriptId) {
        Request request = new Request("script");
        request.getArguments().put("scriptId", scriptId);
        try {
            Response response = this.sendRequest(request, 30000);
            Map jsonScript = (Map)response.getBody().get("script");
            return new ScriptReferenceImpl(this, jsonScript);
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return null;
    }

    public synchronized List allScripts() {
        return new ArrayList(this.scripts.values());
    }

    public synchronized ScriptReferenceImpl addScript(Long scriptId) {
        ScriptReferenceImpl script = (ScriptReferenceImpl)this.scripts.get(scriptId);
        if (script != null) {
            return script;
        }
        script = this.createScriptReference(scriptId);
        if (script != null) {
            this.scripts.put(scriptId, script);
        }
        return script;
    }

    public synchronized ScriptReferenceImpl getScript(Long scriptId) {
        return (ScriptReferenceImpl)this.scripts.get(scriptId);
    }

    public EventPacket receiveEvent(int timeout) throws TimeoutException, DisconnectedException {
        return this.session.receiveEvent(timeout);
    }

    public Response sendRequest(Request request, int timeout) throws TimeoutException, DisconnectedException {
        this.session.sendRequest(request);
        return this.session.receiveResponse(request.getSequence(), timeout);
    }

    public Response sendRequest(Request request) throws TimeoutException, DisconnectedException {
        return this.sendRequest(request, 30000);
    }

    public synchronized List allThreads() {
        Request request = new Request("threads");
        try {
            Response response = this.sendRequest(request);
            List threadIds = (List)response.getBody().get("threads");
            HashMap<Long, ThreadReferenceImpl> allThreads = new HashMap<Long, ThreadReferenceImpl>(threadIds.size());
            Iterator iterator = threadIds.iterator();
            while (iterator.hasNext()) {
                Long threadId = new Long(((Number)iterator.next()).longValue());
                ThreadReferenceImpl thread = (ThreadReferenceImpl)this.threads.get(threadId);
                if (thread == null) {
                    thread = this.createThreadReference(threadId);
                }
                if (thread == null) continue;
                allThreads.put(threadId, thread);
            }
            this.threads = allThreads;
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return new ArrayList(this.threads.values());
    }

    public synchronized ThreadReferenceImpl removeThread(Long threadId) {
        return (ThreadReferenceImpl)this.threads.remove(threadId);
    }

    private ThreadReferenceImpl createThreadReference(Long threadId) {
        Map jsonThread;
        block4: {
            Request request = new Request("thread");
            request.getArguments().put("threadId", threadId);
            Response response = this.sendRequest(request, 30000);
            jsonThread = (Map)response.getBody().get("thread");
            if (jsonThread != null) break block4;
            return null;
        }
        try {
            return new ThreadReferenceImpl(this, jsonThread);
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return null;
    }

    public synchronized ThreadReferenceImpl getThread(Long threadId) {
        ThreadReferenceImpl thread = (ThreadReferenceImpl)this.threads.get(threadId);
        if (thread == null && (thread = this.createThreadReference(threadId)) != null) {
            this.threads.put(threadId, thread);
        }
        return thread;
    }

    public String description() {
        Request request = new Request("version");
        try {
            Response response = this.sendRequest(request);
            StringBuffer buffer = new StringBuffer();
            buffer.append((String)response.getBody().get("javascript.vm.vendor")).append(" ");
            buffer.append(response.getBody().get("javascript.vm.name")).append(" ");
            buffer.append(response.getBody().get("javascript.vm.version"));
            return buffer.toString();
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        Request request = new Request("dispose");
        try {
            try {
                this.sendRequest(request);
            }
            catch (DisconnectedException e) {
                this.disconnectVM();
                this.handleException(e.getMessage(), e);
            }
            catch (TimeoutException e) {
                RhinoDebugPlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.disconnectVM();
            this.eventRequestManager.createVMDeathRequest();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.disconnectVM();
            this.eventRequestManager.createVMDeathRequest();
        }
    }

    public String name() {
        Request request = new Request("version");
        try {
            Response response = this.sendRequest(request);
            return (String)response.getBody().get("javascript.vm.name");
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return null;
    }

    public void resume() {
        Request request = new Request("continue");
        try {
            this.sendRequest(request);
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
    }

    public void suspend() {
        Request request = new Request("suspend");
        try {
            this.sendRequest(request);
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
    }

    public void terminate() {
        this.dispose();
    }

    public String version() {
        Request request = new Request("version");
        try {
            Response response = this.sendRequest(request);
            return (String)response.getBody().get("javascript.vm.version");
        }
        catch (DisconnectedException e) {
            this.disconnectVM();
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnectVM() {
        if (this.disconnected) {
            return;
        }
        try {
            this.session.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.disconnected = true;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.disconnected = true;
            return;
        }
    }

    public BooleanValue mirrorOf(boolean bool) {
        return new BooleanValueImpl(this, bool);
    }

    public NumberValue mirrorOf(Number number) {
        return new NumberValueImpl(this, number);
    }

    public StringValue mirrorOf(String string) {
        return new StringValueImpl(this, string);
    }

    public NullValue mirrorOfNull() {
        return this.nullValue;
    }

    public UndefinedValue mirrorOfUndefined() {
        return this.undefinedValue;
    }

    public EventRequestManager eventRequestManager() {
        return this.eventRequestManager;
    }

    public EventQueue eventQueue() {
        return this.eventQueue;
    }
}

