/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.SortCriterion;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TaskCompareDialog
extends SelectionDialog {
    private Combo[] priorityCombos;
    private Button[] ascendingButtons;
    private Button[] descendingButtons;
    private final String[] propertyText;
    private boolean dirty = false;
    private final TaskComparator taskComparator;
    private String selectedValueLastCombo;
    private final Comparator<String> columnComparator = new Comparator<String>(){

        @Override
        public int compare(String arg0, String arg1) {
            int index0 = -1;
            int index1 = -1;
            int i = 0;
            while (i < TaskCompareDialog.this.propertyText.length) {
                if (TaskCompareDialog.this.propertyText[i].equals(arg0)) {
                    index0 = i;
                }
                if (TaskCompareDialog.this.propertyText[i].equals(arg1)) {
                    index1 = i;
                }
                ++i;
            }
            return index0 - index1;
        }
    };

    public TaskCompareDialog(IShellProvider parentShell, TaskComparator taskComparator) {
        super(parentShell.getShell());
        SortCriterion.SortKey[] values = SortCriterion.SortKey.values();
        this.propertyText = new String[values.length];
        int i = 0;
        while (i < values.length) {
            this.propertyText[i] = values[i].getLabel();
            ++i;
        }
        this.taskComparator = taskComparator;
        this.setTitle(Messages.TaskCompareDialog_Sorting);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        Control control = this.createContentArea(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Control createContentArea(Composite parent) {
        Group prioritiesArea = new Group(parent, 0);
        prioritiesArea.setLayout((Layout)new GridLayout(3, false));
        prioritiesArea.setText(Messages.TaskCompareDialog_Tasks);
        this.ascendingButtons = new Button[SortCriterion.kindCount];
        this.descendingButtons = new Button[SortCriterion.kindCount];
        this.priorityCombos = new Combo[SortCriterion.kindCount];
        int i = 0;
        while (i < SortCriterion.kindCount) {
            final int index = i;
            Label numberLabel = new Label((Composite)prioritiesArea, 0);
            if (i == 0) {
                numberLabel.setText(Messages.TaskCompareDialog_Sort_by);
            } else {
                numberLabel.setText(Messages.TaskCompareDialog_Then_by);
            }
            this.priorityCombos[i] = new Combo((Composite)prioritiesArea, 8);
            this.priorityCombos[i].setLayoutData((Object)new GridData(768));
            Composite directionGroup = new Composite((Composite)prioritiesArea, 0);
            directionGroup.setLayout((Layout)new GridLayout(2, false));
            this.ascendingButtons[i] = new Button(directionGroup, 16);
            this.ascendingButtons[i].setText(Messages.TaskCompareDialog_Ascending);
            this.ascendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskCompareDialog.this.markDirty();
                }
            });
            this.descendingButtons[i] = new Button(directionGroup, 16);
            this.descendingButtons[i].setText(Messages.TaskCompareDialog_Descending);
            this.descendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskCompareDialog.this.markDirty();
                }
            });
            if (i < this.priorityCombos.length) {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String oldSelection;
                        ArrayList<String> oldSelectionList = new ArrayList<String>(Arrays.asList(TaskCompareDialog.this.priorityCombos[index].getItems()));
                        if (index + 1 == SortCriterion.kindCount) {
                            oldSelection = TaskCompareDialog.this.selectedValueLastCombo;
                        } else {
                            oldSelectionList.removeAll(Arrays.asList(TaskCompareDialog.this.priorityCombos[index + 1].getItems()));
                            oldSelection = TaskCompareDialog.this.propertyText[SortCriterion.SortKey.NONE.ordinal()];
                            if (oldSelectionList.size() == 1) {
                                oldSelection = oldSelectionList.get(0);
                            }
                        }
                        String newSelection = TaskCompareDialog.this.priorityCombos[index].getItem(TaskCompareDialog.this.priorityCombos[index].getSelectionIndex());
                        if (oldSelection.equals(newSelection)) {
                            return;
                        }
                        if (index + 1 == SortCriterion.kindCount) {
                            TaskCompareDialog.this.selectedValueLastCombo = newSelection;
                        }
                        if (oldSelection.equals(TaskCompareDialog.this.propertyText[SortCriterion.SortKey.NONE.ordinal()])) {
                            TaskCompareDialog.this.ascendingButtons[index].setEnabled(true);
                            TaskCompareDialog.this.descendingButtons[index].setEnabled(true);
                            if (index + 1 < SortCriterion.kindCount) {
                                TaskCompareDialog.this.priorityCombos[index + 1].setEnabled(true);
                                ArrayList<String> availablePriorities = new ArrayList<String>(Arrays.asList(TaskCompareDialog.this.priorityCombos[index].getItems()));
                                availablePriorities.remove(newSelection);
                                int k = index + 1;
                                while (k < SortCriterion.kindCount) {
                                    TaskCompareDialog.this.priorityCombos[k].removeAll();
                                    int j = 0;
                                    while (j < availablePriorities.size()) {
                                        TaskCompareDialog.this.priorityCombos[k].add(availablePriorities.get(j));
                                        ++j;
                                    }
                                    TaskCompareDialog.this.priorityCombos[k].select(TaskCompareDialog.this.priorityCombos[k].indexOf(TaskCompareDialog.this.propertyText[SortCriterion.SortKey.NONE.ordinal()]));
                                    ++k;
                                }
                            }
                        } else if (newSelection.equals(TaskCompareDialog.this.propertyText[SortCriterion.SortKey.NONE.ordinal()])) {
                            TaskCompareDialog.this.ascendingButtons[index].setEnabled(false);
                            TaskCompareDialog.this.descendingButtons[index].setEnabled(false);
                            if (index + 1 < SortCriterion.kindCount) {
                                ArrayList<String> availablePriorities = new ArrayList<String>(Arrays.asList(TaskCompareDialog.this.priorityCombos[index].getItems()));
                                int k = index + 1;
                                while (k < SortCriterion.kindCount) {
                                    TaskCompareDialog.this.priorityCombos[k].setEnabled(true);
                                    TaskCompareDialog.this.priorityCombos[k].removeAll();
                                    int j = 0;
                                    while (j < availablePriorities.size()) {
                                        TaskCompareDialog.this.priorityCombos[k].add(availablePriorities.get(j));
                                        ++j;
                                    }
                                    TaskCompareDialog.this.priorityCombos[k].select(TaskCompareDialog.this.priorityCombos[k].indexOf(TaskCompareDialog.this.propertyText[SortCriterion.SortKey.NONE.ordinal()]));
                                    TaskCompareDialog.this.priorityCombos[k].setEnabled(false);
                                    TaskCompareDialog.this.ascendingButtons[k].setEnabled(false);
                                    TaskCompareDialog.this.descendingButtons[k].setEnabled(false);
                                    ++k;
                                }
                            }
                        } else {
                            int j = index + 1;
                            while (j < TaskCompareDialog.this.priorityCombos.length) {
                                int newSelectionIndex = TaskCompareDialog.this.priorityCombos[j].indexOf(newSelection);
                                if (TaskCompareDialog.this.priorityCombos[j].getSelectionIndex() == newSelectionIndex) {
                                    TaskCompareDialog.this.priorityCombos[j].remove(newSelection);
                                    int insertionPoint = -1 - Arrays.binarySearch(TaskCompareDialog.this.priorityCombos[j].getItems(), oldSelection, TaskCompareDialog.this.columnComparator);
                                    if (insertionPoint >= 0 && insertionPoint <= TaskCompareDialog.this.priorityCombos[j].getItemCount()) {
                                        TaskCompareDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                    } else {
                                        TaskCompareDialog.this.priorityCombos[j].add(oldSelection);
                                    }
                                    TaskCompareDialog.this.priorityCombos[j].select(TaskCompareDialog.this.priorityCombos[j].indexOf(oldSelection));
                                } else if (newSelectionIndex >= 0) {
                                    String currentText = TaskCompareDialog.this.priorityCombos[j].getText();
                                    TaskCompareDialog.this.priorityCombos[j].remove(newSelection);
                                    int insertionPoint = -1 - Arrays.binarySearch(TaskCompareDialog.this.priorityCombos[j].getItems(), oldSelection, TaskCompareDialog.this.columnComparator);
                                    if (insertionPoint >= 0 && insertionPoint <= TaskCompareDialog.this.priorityCombos[j].getItemCount()) {
                                        TaskCompareDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                        TaskCompareDialog.this.priorityCombos[j].select(TaskCompareDialog.this.priorityCombos[j].indexOf(currentText));
                                    } else {
                                        TaskCompareDialog.this.priorityCombos[j].add(oldSelection);
                                    }
                                }
                                ++j;
                            }
                        }
                        TaskCompareDialog.this.markDirty();
                    }
                });
            } else {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskCompareDialog.this.markDirty();
                    }
                });
            }
            ++i;
        }
        this.updateUI();
        return prioritiesArea;
    }

    protected void okPressed() {
        if (this.isDirty()) {
            int i = 0;
            while (i < SortCriterion.kindCount) {
                SortCriterion keyEntries = this.taskComparator.getSortCriterion(i);
                keyEntries.setKey(SortCriterion.SortKey.valueOfLabel(this.priorityCombos[i].getText()));
                if (this.descendingButtons[i].getSelection()) {
                    keyEntries.setDirection(-1);
                } else {
                    keyEntries.setDirection(1);
                }
                ++i;
            }
        }
        super.okPressed();
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    protected void updateUI() {
        ArrayList<String> availablePriorities = new ArrayList<String>(Arrays.asList(this.propertyText));
        int i = 0;
        while (i < TaskComparator.CRITERIA_COUNT) {
            SortCriterion criterion = this.taskComparator.getSortCriterion(i);
            this.priorityCombos[i].removeAll();
            int j = 0;
            while (j < availablePriorities.size()) {
                this.priorityCombos[i].add(availablePriorities.get(j));
                ++j;
            }
            this.priorityCombos[i].select(this.priorityCombos[i].indexOf(this.propertyText[criterion.getKey().ordinal()]));
            this.ascendingButtons[i].setSelection(criterion.getDirection() == 1);
            this.descendingButtons[i].setSelection(criterion.getDirection() == -1);
            if (i == TaskComparator.CRITERIA_COUNT - 1) {
                this.selectedValueLastCombo = this.propertyText[criterion.getKey().ordinal()];
            }
            if (criterion.getKey() == SortCriterion.SortKey.NONE) {
                this.ascendingButtons[i].setEnabled(false);
                this.descendingButtons[i].setEnabled(false);
                int k = i + 1;
                while (k < TaskComparator.CRITERIA_COUNT) {
                    int j2 = 0;
                    while (j2 < availablePriorities.size()) {
                        this.priorityCombos[k].add(availablePriorities.get(j2));
                        ++j2;
                    }
                    this.priorityCombos[k].select(this.priorityCombos[k].indexOf(this.propertyText[SortCriterion.SortKey.NONE.ordinal()]));
                    if (k == TaskComparator.CRITERIA_COUNT - 1) {
                        this.selectedValueLastCombo = this.propertyText[SortCriterion.SortKey.NONE.ordinal()];
                    }
                    this.ascendingButtons[k].setSelection(this.taskComparator.getSortCriterion(k).getDirection() == 1);
                    this.descendingButtons[k].setSelection(this.taskComparator.getSortCriterion(k).getDirection() == -1);
                    this.priorityCombos[k].setEnabled(false);
                    this.ascendingButtons[k].setEnabled(false);
                    this.descendingButtons[k].setEnabled(false);
                    ++k;
                }
                break;
            }
            availablePriorities.remove(this.propertyText[criterion.getKey().ordinal()]);
            ++i;
        }
    }
}

