/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.workingsets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class TaskWorkingSetElementFactory
implements IElementFactory {
    static final String HANDLE_TASK = "handle.task";
    static final String HANDLE_PROJECT = "handle.project";

    public IAdaptable createElement(IMemento memento) {
        IProject project;
        String projectHandle;
        String taskHandle = memento.getString(HANDLE_TASK);
        if (taskHandle != null) {
            TaskList taskList = TasksUiPlugin.getTaskList();
            for (AbstractTaskContainer element : taskList.getRootElements()) {
                if (!element.getHandleIdentifier().equals(taskHandle)) continue;
                return element;
            }
        }
        if ((projectHandle = memento.getString(HANDLE_PROJECT)) != null) {
            try {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectHandle);
                if (project != null) {
                    return project;
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not not determine project for handle: " + projectHandle, t));
            }
        }
        if (taskHandle != null) {
            try {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(taskHandle);
                if (project != null) {
                    return project;
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not not determine project for handle: " + taskHandle, t));
            }
        }
        return null;
    }
}

