/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public abstract class AntGeneratingExportWizard
extends BaseExportWizard {
    protected BaseExportWizardPage fPage;

    public void addPages() {
        this.fPage = this.createPage1();
        this.addPage((IWizardPage)this.fPage);
    }

    protected abstract BaseExportWizardPage createPage1();

    protected boolean performPreliminaryChecks() {
        if (!"always".equals(PDEPlugin.getDefault().getPreferenceStore().getString("Preferences.MainPage.overwriteBuildFilesOnExport"))) {
            Object[] objects = this.fPage.getSelectedItems();
            ArrayList<Object> problemModels = new ArrayList<Object>();
            int i = 0;
            while (i < objects.length) {
                File file;
                Object object = objects[i];
                String installLocation = null;
                IResource underlyingResource = null;
                if (object instanceof WorkspacePluginModelBase) {
                    installLocation = ((WorkspacePluginModelBase)object).getInstallLocation();
                    underlyingResource = ((WorkspacePluginModelBase)object).getUnderlyingResource();
                } else if (object instanceof WorkspaceFeatureModel) {
                    installLocation = ((WorkspaceFeatureModel)object).getInstallLocation();
                    underlyingResource = ((WorkspaceFeatureModel)object).getUnderlyingResource();
                }
                if (installLocation != null && underlyingResource != null && (file = new File(installLocation, "build.xml")).exists()) {
                    try {
                        IFile buildFile = PDEProject.getBuildProperties((IProject)underlyingResource.getProject());
                        WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
                        buildModel.load();
                        IBuildEntry entry = buildModel.getBuild().getEntry("custom");
                        if (entry == null || !entry.contains("true")) {
                            problemModels.add(object);
                        }
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
                ++i;
            }
            if (problemModels.size() > 0) {
                StringBuffer buf = new StringBuffer();
                PDELabelProvider labelProvider = new PDELabelProvider();
                int maxCount = 10;
                Iterator iterator = problemModels.iterator();
                while (iterator.hasNext()) {
                    buf.append(labelProvider.getText(iterator.next()));
                    buf.append('\n');
                    if (--maxCount > 0) continue;
                    buf.append("...");
                    break;
                }
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)PDEUIMessages.AntGeneratingExportWizard_0, (String)MessageFormat.format((String)PDEUIMessages.AntGeneratingExportWizard_1, (Object[])new String[]{buf.toString()}), (String)PDEUIMessages.AntGeneratingExportWizard_2, (boolean)false, (IPreferenceStore)PDEPlugin.getDefault().getPreferenceStore(), (String)"Preferences.MainPage.overwriteBuildFilesOnExport");
                if (dialog.getReturnCode() == 1) {
                    return false;
                }
            }
        }
        if (this.fPage.doGenerateAntFile()) {
            this.generateAntBuildFile(this.fPage.getAntBuildFileName());
        }
        return true;
    }

    protected boolean confirmDelete() {
        File zipFile;
        if (!this.fPage.doExportToDirectory() && (zipFile = new File(this.fPage.getDestination(), this.fPage.getFileName())).exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)PDEUIMessages.BaseExportWizard_confirmReplace_title, (String)NLS.bind((String)PDEUIMessages.BaseExportWizard_confirmReplace_desc, (Object)zipFile.getAbsolutePath()))) {
                return false;
            }
            zipFile.delete();
        }
        return true;
    }

    protected abstract Document generateAntTask();

    protected void generateAntBuildFile(String filename) {
        File dir;
        String parent = new Path(filename).removeLastSegments(1).toOSString();
        String buildFilename = new Path(filename).lastSegment();
        if (!buildFilename.endsWith(".xml")) {
            buildFilename = String.valueOf(buildFilename) + ".xml";
        }
        if (!(dir = new File(new File(parent).getAbsolutePath())).exists()) {
            dir.mkdirs();
        }
        try {
            Document task = this.generateAntTask();
            if (task != null) {
                File buildFile = new File(dir, buildFilename);
                XMLPrintHandler.writeFile((Document)task, (File)buildFile);
                this.generateAntTask();
                this.setDefaultValues(dir, buildFilename);
            }
        }
        catch (IOException iOException) {}
    }

    private void setDefaultValues(File dir, String buildFilename) {
        try {
            IProject project;
            IContainer container = PDEPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir.toString()));
            if (container != null && container.exists() && (project = container.getProject()) != null) {
                project.refreshLocal(2, null);
                IFile file = container.getFile((IPath)new Path(buildFilename));
                if (file.exists()) {
                    BaseBuildAction.setDefaultValues(file);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected String getExportOperation() {
        return this.fPage.doExportToDirectory() ? "directory" : "zip";
    }

    protected class AntErrorDialog
    extends MessageDialog {
        private File fLogLocation;

        public AntErrorDialog(File logLocation) {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, null, null, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.fLogLocation = logLocation;
        }

        protected Control createMessageArea(Composite composite) {
            Link link = new Link(composite, 64);
            try {
                link.setText(NLS.bind((String)PDEUIMessages.PluginExportWizard_Ant_errors_during_export_logs_generated, (Object)("<a>" + this.fLogLocation.getCanonicalPath() + "</a>")));
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
            GridData data = new GridData();
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            link.setLayoutData((Object)data);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AntErrorDialog this$1;
                {
                    this.this$1 = antErrorDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Program.launch((String)AntErrorDialog.access$0(this.this$1).getCanonicalPath());
                    }
                    catch (IOException ex) {
                        PDEPlugin.log(ex);
                    }
                }
            });
            return link;
        }

        static /* synthetic */ File access$0(AntErrorDialog antErrorDialog) {
            return antErrorDialog.fLogLocation;
        }
    }
}

