/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

public class ServerContentProvider
extends BaseContentProvider
implements ITreeContentProvider {
    public static Object INITIALIZING = new Object();
    protected static Set<String> publishing = new HashSet<String>(4);

    public Object[] getElements(Object element) {
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (!((Server)servers[i]).isPrivate()) {
                    list.add(servers[i]);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    public Object[] getChildren(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            try {
                IModule[] children = ms.server.getChildModules(ms.module, null);
                int size = children.length;
                Object[] ms2 = new ModuleServer[size];
                int i = 0;
                while (i < size) {
                    int size2 = ms.module.length;
                    IModule[] module = new IModule[size2 + 1];
                    System.arraycopy(ms.module, 0, module, 0, size2);
                    module[size2] = children[i];
                    ms2[i] = new ModuleServer(ms.server, module);
                    ++i;
                }
                return ms2;
            }
            catch (Exception exception) {
                return null;
            }
        }
        IServer server = (IServer)element;
        IModule[] modules = server.getModules();
        int size = modules.length;
        Object[] ms = new ModuleServer[size];
        int i = 0;
        while (i < size) {
            ms[i] = new ModuleServer(server, new IModule[]{modules[i]});
            ++i;
        }
        return ms;
    }

    public Object getParent(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            return ms.server;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer curModuleServer = (ModuleServer)element;
            IServer curServer = curModuleServer.server;
            IModule[] curModule = curModuleServer.module;
            if (curServer != null && curModule != null) {
                IModule[] curChildModule = curServer.getChildModules(curModule, null);
                return curChildModule != null && curChildModule.length > 0;
            }
            return false;
        }
        if (element instanceof IServer) {
            return ((IServer)element).getModules().length > 0;
        }
        return false;
    }
}

