/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.swtutils;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SWTUtils {
    public static final int COLORDIALOG_WIDTH = 222;
    public static final int COLORDIALOG_HEIGHT = 306;

    public static Label drawLabel(Composite parent, String text, int syle, Object layoutData) {
        Label label = new Label(parent, 0);
        label.setText(text);
        if (layoutData != null) {
            label.setLayoutData(layoutData);
        }
        return label;
    }

    public static Text drawText(Composite parent, int style, Object layoutData) {
        Text text = new Text(parent, style);
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        return text;
    }

    public static Combo drawCombo(Composite parent, int style, Object layoutData) {
        Combo combo = new Combo(parent, 2048);
        if (layoutData != null) {
            combo.setLayoutData(layoutData);
        }
        return combo;
    }

    public static Button drawButton(Composite parent, int style, String text, Object layoutData) {
        Button button = new Button(parent, style);
        if (layoutData != null) {
            button.setLayoutData(layoutData);
        }
        return button;
    }

    public static Label drawColorPicker(Composite parent, Object layoutData) {
        Composite innerSection = new Composite(parent, 0);
        GridLayout colorGd = new GridLayout();
        colorGd.numColumns = 2;
        colorGd.marginHeight = 0;
        colorGd.marginBottom = 0;
        innerSection.setLayout((Layout)colorGd);
        Label colorLabel = new Label(innerSection, 2048);
        colorLabel.setText("          ");
        RGB rgb = null;
        rgb = new RGB(0, 255, 0);
        Color color = new Color((Device)parent.getDisplay(), rgb);
        colorLabel.setBackground(color);
        String newHexadecimal = SWTUtils.convertRGBToHexadecimal(rgb);
        colorLabel.setData((Object)newHexadecimal);
        Button button = new Button(innerSection, 8);
        button.setText("Color...");
        Shell parentShell = parent.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell centerShell = new Shell(parentShell, 8);
                centerShell.setLocation((parentShell.getSize().x - 222) / 2, (parentShell.getSize().y - 306) / 2);
                ColorDialog colorDg = new ColorDialog(centerShell, 65536);
                colorDg.setRGB(colorLabel.getBackground().getRGB());
                RGB rgb = colorDg.open();
                if (rgb != null) {
                    color.dispose();
                    Color newColor = new Color((Device)parentShell.getDisplay(), rgb);
                    colorLabel.setBackground(newColor);
                    String newHexadecimal = SWTUtils.convertRGBToHexadecimal(rgb);
                    colorLabel.setData((Object)newHexadecimal);
                }
                centerShell.dispose();
            }
        });
        return colorLabel;
    }

    public static Spinner drawSpinner(Composite parent, int style, Object layoutData, int minimum, int maximum, int digits) {
        Spinner spinner = new Spinner(parent, style);
        if (digits > -1) {
            spinner.setDigits(digits);
        }
        spinner.setMaximum(maximum);
        spinner.setMinimum(minimum);
        return spinner;
    }

    public static GridData setGridLayoutData(int align, int horizontalSpan) {
        GridData gName = new GridData(align);
        if (horizontalSpan > 0) {
            gName.horizontalSpan = horizontalSpan;
        }
        return gName;
    }

    public static void drawEmptyLabel(Composite composite) {
        Label emptyLabel = new Label(composite, 0);
        emptyLabel.setText("");
    }

    public static String convertRGBToHexadecimal(RGB rgb) {
        int red = rgb.red;
        int green = rgb.green;
        int blue = rgb.blue;
        String redHexadecimal = Integer.toHexString(red);
        String greenHexadecimal = Integer.toHexString(green);
        String blueHexadecimal = Integer.toHexString(blue);
        if (redHexadecimal.length() == 1) {
            redHexadecimal = "0" + redHexadecimal;
        }
        if (greenHexadecimal.length() == 1) {
            greenHexadecimal = "0" + greenHexadecimal;
        }
        if (blueHexadecimal.length() == 1) {
            blueHexadecimal = "0" + blueHexadecimal;
        }
        return "#" + redHexadecimal + greenHexadecimal + blueHexadecimal;
    }

    public static RGB convertHexadecimalToRGB(String hexadecimal) throws NumberFormatException {
        java.awt.Color col = null;
        try {
            col = java.awt.Color.decode(hexadecimal);
        }
        catch (Exception exception) {
            col = java.awt.Color.WHITE;
        }
        int red = col.getRed();
        int blue = col.getBlue();
        int green = col.getGreen();
        return new RGB(red, green, blue);
    }

    public static Integer convertValueForSpinner(double d) {
        int indexPoint;
        Double doubleVal = d;
        String doubleString = doubleVal.toString();
        String afterPoint = doubleString.substring((indexPoint = doubleString.indexOf(46)) + 1, doubleString.length());
        if (afterPoint.length() == 1) {
            doubleString = String.valueOf(doubleString) + 0;
        } else if (afterPoint.length() == 0) {
            doubleString = String.valueOf(doubleString) + 0;
        }
        doubleString = SWTUtils.removeChar(doubleString, '.');
        Integer fakeIntVal = Integer.valueOf(doubleString);
        return fakeIntVal;
    }

    private static String removeChar(String s, char c) {
        String r = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != c) {
                r = String.valueOf(r) + s.charAt(i);
            }
            ++i;
        }
        return r;
    }
}

