/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs;

import java.util.HashMap;
import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs.ThresholdValueTabItem;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.emf.SbiThresholdTransactions;
import org.eclipse.ebam.emf.SbiThresholdValueTransactions;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.ebam.model.entities.SbiThresholdValue;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdValueTabFunctions {
    ThresholdValueTabItem item;
    private static Logger logger = LoggerFactory.getLogger(ThresholdValueTabFunctions.class);

    public ThresholdValueTabFunctions(ThresholdValueTabItem item) {
        this.item = item;
    }

    public void addThresholdValueSelection(TableItem tableItem) throws Exception {
        String color;
        logger.debug("IN");
        this.disableValueDetail();
        HashMap map = (HashMap)tableItem.getData();
        Integer id = (Integer)map.get("id");
        SbiThresholdValue thValue = new SbiThresholdValueTransactions().getSbiThresholdValueById(id);
        String label = thValue.getLabel();
        if (label == null) {
            label = "";
        }
        if ((color = thValue.getColour()) == null) {
            color = "";
        }
        int maxClosed = thValue.getMaxClosed();
        int minClosed = thValue.getMinClosed();
        thValue.getPosition();
        double maxValue = thValue.getMaxValue();
        double minValue = thValue.getMinValue();
        double value = thValue.getThValue();
        SbiDomain severity = thValue.getSbiDomain();
        this.item.getLabelText().setText(thValue.getLabel());
        if (minClosed > 0) {
            this.item.getMinClosedCheck().setSelection(true);
        } else {
            this.item.getMinClosedCheck().setSelection(false);
        }
        if (maxClosed > 0) {
            this.item.getMaxClosedCheck().setSelection(true);
        } else {
            this.item.getMaxClosedCheck().setSelection(false);
        }
        Integer maxInt = SWTUtils.convertValueForSpinner(maxValue);
        this.item.getMaxSpinner().setSelection(maxInt.intValue());
        Integer minInt = SWTUtils.convertValueForSpinner(minValue);
        this.item.getMinSpinner().setSelection(minInt.intValue());
        Integer valueInt = SWTUtils.convertValueForSpinner(value);
        this.item.getThValueSpinner().setSelection(valueInt.intValue());
        String[] items = this.item.getSeverityCombo().getItems();
        int i = 0;
        while (i < items.length) {
            String name = items[i];
            if (name.equalsIgnoreCase(severity.getValueCd())) {
                this.item.getSeverityCombo().select(i);
            }
            ++i;
        }
        this.item.getColorLabel().setData((Object)color);
        this.item.getColorLabel().setBackground(new Color((Device)this.item.getButtonAdd().getDisplay(), SWTUtils.convertHexadecimalToRGB(color)));
        this.setPageAfterThresholdValueSelection();
        int index = this.item.getThresValueTable().getSelectionIndex();
        this.item.getThresValueTable().getItemCount();
        if (this.item.getThresValueTable().getItemCount() - 1 == index) {
            this.item.getButtonErase().setEnabled(true);
        } else {
            this.item.getButtonErase().setEnabled(false);
        }
        logger.debug("OUT");
    }

    private void setPageAfterThresholdValueSelection() {
        this.item.getButtonAdd().setEnabled(false);
        this.item.getButtonSaveValue().setEnabled(true);
        this.item.getButtonAdd().setEnabled(true);
        this.item.getButtonErase().setEnabled(true);
        this.item.getButtonSaveValue().setVisible(true);
        this.item.getLabelText().setEditable(false);
    }

    public void eraseThresholdValuePush() throws DatabaseConnectionException {
        logger.debug("IN");
        Table table = this.item.getThresValueTable();
        int indexSelected = table.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = table.getItem(indexSelected);
            HashMap map = (HashMap)tableItem.getData();
            Integer id = (Integer)map.get("id");
            SbiThresholdValue sbiThresholdValue = null;
            try {
                sbiThresholdValue = new SbiThresholdValueTransactions().getSbiThresholdValueById(id);
                new SbiThresholdValueTransactions().deleteSbiThresholdValue(sbiThresholdValue);
            }
            catch (Exception e) {
                logger.error("error in erasing threshold value, probably associated to an existing alarm");
                throw new DatabaseConnectionException(e, "error in erasing threshold value, probably associated to an existing alarm");
            }
            table.remove(indexSelected);
            table.redraw();
            this.setPageAfterEraseButtonPush(table);
        }
        logger.debug("OUT");
    }

    private void setPageAfterEraseButtonPush(Table table) {
        table.setSelection(-1);
        this.disableValueDetail();
        this.item.getButtonSaveValue().setVisible(false);
    }

    public void saveValueButtonPush(Integer thresholdId) throws Exception {
        SbiThresholdValue sbiThresholdValue;
        boolean updating = false;
        int selectedIndex = this.item.getThresValueTable().getSelectionIndex();
        if (selectedIndex != -1) {
            updating = true;
            TableItem itemSel = this.item.getThresValueTable().getItem(selectedIndex);
            HashMap map = (HashMap)itemSel.getData();
            Integer id = (Integer)map.get("id");
            sbiThresholdValue = new SbiThresholdValueTransactions().getSbiThresholdValueById(id);
        } else {
            updating = false;
            sbiThresholdValue = new SbiThresholdValue();
        }
        String label = this.item.getLabelText().getText();
        String valueS = this.item.getThValueSpinner().getText();
        String minS = this.item.getMinSpinner().getText();
        String maxS = this.item.getMaxSpinner().getText();
        boolean minClosed = this.item.getMinClosedCheck().getSelection();
        boolean maxClosed = this.item.getMaxClosedCheck().getSelection();
        String color = (String)this.item.getColorLabel().getData();
        valueS = valueS.replaceAll(",", ".");
        Double value = Double.valueOf(valueS);
        maxS = maxS.replaceAll(",", ".");
        Double max = Double.valueOf(maxS);
        minS = minS.replaceAll(",", ".");
        Double min = Double.valueOf(minS);
        int minClosedInt = minClosed ? 1 : 0;
        int maxClosedInt = maxClosed ? 1 : 0;
        int domainIndex = this.item.getSeverityCombo().getSelectionIndex();
        SbiDomain domain = null;
        if (domainIndex != -1) {
            String severityCode = this.item.getSeverityCombo().getItem(domainIndex);
            domain = new SbiDomainTransactions().getSbiDomainByCodeAndDomainCd(severityCode, "SEVERITY");
        }
        int position = -1;
        position = !updating ? this.item.getThresValueTable().getItemCount() : sbiThresholdValue.getPosition();
        SbiThreshold threshold = new SbiThresholdTransactions().getSbiThresholdById(thresholdId);
        sbiThresholdValue.setLabel(label);
        sbiThresholdValue.setColour(color);
        sbiThresholdValue.setMinValue(min.doubleValue());
        sbiThresholdValue.setMaxValue(max.doubleValue());
        sbiThresholdValue.setThValue(value.doubleValue());
        sbiThresholdValue.setMinClosed(minClosedInt);
        sbiThresholdValue.setMaxClosed(maxClosedInt);
        sbiThresholdValue.setSbiDomain(domain);
        sbiThresholdValue.setSbiThreshold(threshold);
        sbiThresholdValue.setPosition(position);
        if (!updating) {
            new SbiThresholdValueTransactions().createNewSbiThresholdValue(sbiThresholdValue);
            sbiThresholdValue.getIdThresholdValue();
            Table table = this.item.getThresValueTable();
            TableItem tableItem = new TableItem(table, 0);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("id", sbiThresholdValue.getIdThresholdValue());
            map.put("position", position);
            tableItem.setData(map);
            tableItem.setText(0, Integer.valueOf(position).toString());
            tableItem.setText(1, sbiThresholdValue.getLabel());
        } else {
            new SbiThresholdValueTransactions().mergeSbiThresholdValue(sbiThresholdValue);
            sbiThresholdValue.getIdThresholdValue();
        }
        this.item.getThresValueTable().setSelection(-1);
        logger.debug("OUT");
    }

    public void addAddButtonPush(Integer thresholdId) throws Exception {
        this.fillEmptyValues();
        this.item.getButtonSaveValue().setVisible(true);
        this.item.getButtonSaveValue().redraw();
        this.item.getLabelText().setEditable(true);
        this.item.getThresValueTable().setSelection(-1);
    }

    public void fillEmptyValues() {
        this.item.getLabelText().setText("");
        this.item.getThValueSpinner().setSelection(0);
        this.item.getSeverityCombo().select(0);
        this.item.getMinSpinner().setSelection(0);
        this.item.getMaxSpinner().setSelection(0);
        this.item.getMinClosedCheck().setSelection(false);
        this.item.getMaxClosedCheck().setSelection(false);
    }

    public void disableValueDetail() {
        this.item.getLabelText().setEnabled(false);
        this.item.getThValueSpinner().setEnabled(false);
        this.item.getSeverityCombo().setEnabled(false);
        this.item.getMinSpinner().setEnabled(false);
        this.item.getMaxSpinner().setEnabled(false);
        this.item.getMinClosedCheck().setEnabled(false);
        this.item.getMaxClosedCheck().setEnabled(false);
        this.item.getButtonSaveValue().setEnabled(false);
    }

    public void enableValueDetail(TableItem tableItem) {
        this.item.getLabelText().setEnabled(true);
        this.item.getThValueSpinner().setEnabled(true);
        this.item.getSeverityCombo().setEnabled(true);
        this.item.getMinSpinner().setEnabled(true);
        this.item.getMaxSpinner().setEnabled(true);
        this.item.getMinClosedCheck().setEnabled(true);
        this.item.getMaxClosedCheck().setEnabled(true);
        this.item.getButtonSaveValue().setEnabled(true);
        if (tableItem != null) {
            boolean up = this.canMoveUpItem(tableItem);
            boolean down = this.canMoveDownItem(tableItem);
            this.item.getButtonUp().setEnabled(up);
            this.item.getButtonDown().setEnabled(down);
        }
    }

    public void fillValueDetailForType(String type) {
        logger.debug("IN");
        boolean minimum = false;
        boolean maximum = false;
        if (type.equalsIgnoreCase("MINIMUM")) {
            minimum = true;
        } else if (type.equalsIgnoreCase("MAXIMUM")) {
            maximum = true;
        } else if (type.equalsIgnoreCase("RANGE")) {
            minimum = true;
            maximum = true;
        }
        this.item.getMinSpinner().setVisible(minimum);
        this.item.getMaxSpinner().setVisible(maximum);
        logger.debug("OUT");
    }

    public void moveUpItem(Integer selectionIndex) throws Exception {
        Table table = this.item.getThresValueTable();
        TableItem selectedItem = table.getItem(selectionIndex.intValue());
        TableItem itemToSwap = table.getItem(selectionIndex - 1);
        this.swapItems(table, selectedItem, itemToSwap);
        table.select(selectionIndex - 1);
    }

    public void swapItems(Table table, TableItem selectedItem, TableItem itemToSwap) throws Exception {
        if (itemToSwap == null) {
            return;
        }
        HashMap selectedData = (HashMap)selectedItem.getData();
        HashMap swapData = (HashMap)itemToSwap.getData();
        Integer selectedId = (Integer)selectedData.get("id");
        Integer swapId = (Integer)swapData.get("id");
        Integer cfr_ignored_0 = (Integer)selectedData.get("position");
        Integer cfr_ignored_1 = (Integer)swapData.get("position");
        SbiThresholdValueTransactions thTransaction = new SbiThresholdValueTransactions();
        SbiThresholdValue selThresValue = thTransaction.getSbiThresholdValueById(selectedId);
        SbiThresholdValue swapThresValue = thTransaction.getSbiThresholdValueById(swapId);
        Integer positionToSwap = selThresValue.getPosition();
        Integer positionSelect = swapThresValue.getPosition();
        selThresValue.setPosition(positionSelect.intValue());
        swapThresValue.setPosition(positionToSwap.intValue());
        selectedData.put("id", swapId);
        swapData.put("id", selectedId);
        selectedItem.setText(1, swapThresValue.getLabel());
        itemToSwap.setText(1, selThresValue.getLabel());
        thTransaction.mergeSbiThresholdValue(selThresValue);
        thTransaction.mergeSbiThresholdValue(swapThresValue);
    }

    public void moveDownItem(Integer selectionIndex) throws Exception {
        Table table = this.item.getThresValueTable();
        TableItem selectedItem = table.getItem(selectionIndex.intValue());
        TableItem itemToSwap = table.getItem(selectionIndex + 1);
        this.swapItems(table, selectedItem, itemToSwap);
        table.select(selectionIndex + 1);
    }

    public boolean canMoveUpItem(TableItem tableItem) {
        boolean toReturn = false;
        HashMap map = (HashMap)tableItem.getData();
        Integer position = (Integer)map.get("position");
        if (position > 0) {
            toReturn = true;
        }
        return toReturn;
    }

    public boolean canMoveDownItem(TableItem tableItem) {
        boolean toReturn = false;
        HashMap map = (HashMap)tableItem.getData();
        Integer position = (Integer)map.get("position");
        Integer compare = this.item.getThresValueTable().getItemCount() - 1;
        if (position < compare) {
            toReturn = true;
        }
        return toReturn;
    }
}

