/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.NumberUtil;

public final class SharedScaleContext {
    private ScaleContext scaleContext;
    private List<Object> alMinmax = new ArrayList<Object>(2);
    private boolean bShared = false;

    public SharedScaleContext(ScaleContext scaleContext, Object realMin, Object realMax) {
        this.scaleContext = scaleContext;
        this.alMinmax.add(realMin);
        this.alMinmax.add(realMax);
    }

    public static final SharedScaleContext createInstance(Object oMin, Object oMax) {
        ScaleContext sct = ScaleContext.createSimpleScale(oMin, oMax);
        return new SharedScaleContext(sct, sct.getMin(), sct.getMax());
    }

    public final ScaleContext getScaleContext() {
        return this.scaleContext;
    }

    public final void setScaleContext(ScaleContext scaleContext) {
        this.scaleContext = scaleContext;
    }

    public final boolean isShared() {
        return this.bShared;
    }

    public final void setShared(boolean shared) {
        this.bShared = shared;
    }

    public final DataSetIterator createDataSetIterator(int iDataType) throws ChartException, IllegalArgumentException {
        if ((iDataType & 1) == 1) {
            ArrayList<Object> minmax = new ArrayList<Object>(2);
            for (Object o : this.alMinmax) {
                if (o instanceof Number) {
                    minmax.add(((Number)o).doubleValue());
                    continue;
                }
                minmax.add(o);
            }
            return new DataSetIterator(minmax, iDataType);
        }
        return new DataSetIterator(this.alMinmax, iDataType);
    }

    public final DataSetIterator createDataSetIterator(int iDataType, boolean isBigNumber, BigDecimal divisor) throws ChartException, IllegalArgumentException {
        if (isBigNumber) {
            ArrayList<BigNumber> minmax = new ArrayList<BigNumber>(2);
            for (Object o : this.alMinmax) {
                minmax.add(NumberUtil.asBigNumber(NumberUtil.transformNumber(o), divisor));
            }
            return new DataSetIterator(minmax, iDataType);
        }
        return this.createDataSetIterator(iDataType);
    }
}

