/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

public class LinkedFix
extends AbstractFix {
    private final IFixRewriteOperation[] fFixRewrites;
    private final JavaScriptUnit fCompilationUnit;
    private final LinkedProposalModel fLinkedProposalModel;

    protected LinkedFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewrites) {
        super(name, compilationUnit, fixRewrites);
        this.fCompilationUnit = compilationUnit;
        this.fFixRewrites = fixRewrites;
        this.fLinkedProposalModel = new LinkedProposalModel();
    }

    public LinkedProposalModel getLinkedPositions() {
        return this.fLinkedProposalModel;
    }

    public TextChange createChange() throws CoreException {
        if (this.fFixRewrites == null || this.fFixRewrites.length == 0) {
            return null;
        }
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((IJavaScriptUnit)this.fCompilationUnit.getJavaElement(), this.fCompilationUnit);
        ArrayList groups = new ArrayList();
        this.fLinkedProposalModel.clear();
        int i = 0;
        while (i < this.fFixRewrites.length) {
            IFixRewriteOperation operation = this.fFixRewrites[i];
            if (operation instanceof ILinkedFixRewriteOperation) {
                ILinkedFixRewriteOperation linkedOperation = (ILinkedFixRewriteOperation)operation;
                linkedOperation.rewriteAST(cuRewrite, groups, this.fLinkedProposalModel);
            } else {
                operation.rewriteAST(cuRewrite, groups);
            }
            ++i;
        }
        CompilationUnitChange result = cuRewrite.createChange(this.getDescription(), true, null);
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            TextEditGroup group = (TextEditGroup)iter.next();
            result.addTextEditGroup(group);
        }
        return result;
    }

    public static abstract class AbstractLinkedFixRewriteOperation
    extends AbstractFix.AbstractFixRewriteOperation
    implements ILinkedFixRewriteOperation {
        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            this.rewriteAST(cuRewrite, textEditGroups, new LinkedProposalModel());
        }
    }
}

