/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.DriverManager;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ConnectionManager {
    private static volatile ConnectionManager sm_instance = null;
    private static final String DTP_CONN_PROFILE_APPL_ID = "org.eclipse.datatools.connectivity.oda.profile.connectionPropertyService";
    private static final String sm_className = ConnectionManager.class.getName();
    static final String sm_packageName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = null;

    protected ConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ConnectionManager getInstance() {
        ConnectionManager.getLogger().entering(sm_className, "getInstance");
        if (sm_instance == null) {
            Class<ConnectionManager> clazz = ConnectionManager.class;
            // MONITORENTER : org.eclipse.birt.data.engine.odaconsumer.ConnectionManager.class
            if (sm_instance == null) {
                sm_instance = new ConnectionManager();
            }
            // MONITOREXIT : clazz
        }
        ConnectionManager.getLogger().exiting(sm_className, "getInstance", sm_instance);
        return sm_instance;
    }

    public static void releaseInstance() {
        DriverManager.releaseInstance();
        sm_instance = null;
        sm_logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogHelper getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = LogHelper.getInstance(sm_packageName);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    public Connection openConnection(String dataSourceElementId, Properties connectionProperties) throws DataException {
        return this.openConnection(dataSourceElementId, connectionProperties, null);
    }

    public Connection openConnection(String dataSourceElementId, Properties connectionProperties, Map appContext) throws DataException {
        if (ConnectionManager.getLogger().isLoggingEnterExitLevel()) {
            ConnectionManager.getLogger().entering(sm_className, "openConnection", new Object[]{dataSourceElementId, connectionProperties});
        }
        try {
            DriverManager driverMgr = DriverManager.getInstance();
            IDriver driverHelper = driverMgr.getDriverHelper(dataSourceElementId);
            String dataSourceId = driverMgr.getExtensionDataSourceId(dataSourceElementId);
            appContext = ConnectionManager.addProfileProviderService(appContext);
            driverHelper.setAppContext((Object)appContext);
            IConnection connection = driverHelper.getConnection(dataSourceId);
            connection.open(connectionProperties);
            Connection ret = new Connection(connection, dataSourceElementId);
            ConnectionManager.getLogger().exiting(sm_className, "openConnection", ret);
            return ret;
        }
        catch (OdaException ex) {
            ConnectionManager.getLogger().logp(Level.SEVERE, sm_className, "openConnection", "Unable to open connection.", ex);
            throw ExceptionHandler.newException("odaconsumer.CannotOpenConnection", new Object[]{dataSourceElementId}, ex);
        }
        catch (UnsupportedOperationException ex) {
            ConnectionManager.getLogger().logp(Level.SEVERE, sm_className, "openConnection", "Unable to open connection.", ex);
            throw ExceptionHandler.newException("odaconsumer.CannotOpenConnection", new Object[]{dataSourceElementId}, ex);
        }
    }

    static Map addProfileProviderService(Map appContext) {
        HashMap<String, String> providerAppContext = appContext;
        if (providerAppContext == null) {
            providerAppContext = new HashMap<String, String>();
        }
        if (!providerAppContext.containsKey("OdaConsumerId")) {
            providerAppContext.put("OdaConsumerId", DTP_CONN_PROFILE_APPL_ID);
            if (ConnectionManager.getLogger().isLoggable(Level.FINE)) {
                ConnectionManager.getLogger().logp(Level.FINE, sm_className, "addProfileProviderService( Map )", "Added default property service: org.eclipse.datatools.connectivity.oda.profile.connectionPropertyService");
            }
        }
        return providerAppContext;
    }

    public int getMaxConnections(String driverName) throws DataException {
        ConnectionManager.getLogger().entering(sm_className, "getMaxConnections", driverName);
        int maxConnections = 0;
        try {
            IDriver driverHelper = DriverManager.getInstance().getDriverHelper(driverName);
            if (driverHelper != null) {
                maxConnections = driverHelper.getMaxConnections();
            }
        }
        catch (OdaException ex) {
            ConnectionManager.getLogger().logp(Level.WARNING, sm_className, "getMaxConnections", "Cannot get max connections.", ex);
            maxConnections = 0;
        }
        catch (UnsupportedOperationException ex) {
            ConnectionManager.getLogger().logp(Level.INFO, sm_className, "getMaxConnections", "Cannot get max connections.", ex);
            maxConnections = 0;
        }
        ConnectionManager.getLogger().exiting(sm_className, "getMaxConnections", maxConnections);
        return maxConnections;
    }
}

