/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.bidi.utils.core;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.report.data.bidi.utils.core.BidiConstants;
import org.eclipse.birt.report.data.bidi.utils.core.BidiFormat;

public class BidiEngine
extends Bidi {
    private static final int CORE_LTR = 0;
    private static final int CORE_RTL = 1;
    private static final int REVERSE = 2;
    private static final int SHAPE = 3;
    public static BidiEngine INSTANCE = new BidiEngine();
    private List<BidiScheme> reorderingSchemes;
    private List<BidiScheme> shapingSchemes;

    private BidiEngine() {
        this.initReorderingSchemes();
        this.initShapingSchemes();
    }

    public String process(String txt, String inFormat, String outFormat) {
        if (!this.isBidi(txt, inFormat, outFormat) || !BidiFormat.isValidBidiFormat(inFormat) || !BidiFormat.isValidBidiFormat(outFormat) || inFormat.equals(outFormat)) {
            return txt;
        }
        this.normalizeFormat(inFormat, txt);
        this.normalizeFormat(outFormat, txt);
        ListIterator<BidiScheme> it = this.reorderingSchemes.listIterator();
        while (it.hasNext()) {
            BidiScheme scheme = it.next();
            if (!inFormat.matches(scheme.inFormat) || !outFormat.matches(scheme.outFormat)) continue;
            String outStr = txt;
            boolean doMirroring = inFormat.charAt(2) != outFormat.charAt(2);
            int shapeOptions = this.getShapingOptions(inFormat, outFormat);
            int[] procedures = (int[])scheme.data;
            int i = 0;
            int n = procedures.length;
            while (i < n) {
                if (shapeOptions != 0 && 3 == procedures[i]) {
                    outStr = this.shape(outStr, shapeOptions);
                } else if (procedures[i] == 0) {
                    outStr = this.coreLTR(outStr, doMirroring);
                    doMirroring = false;
                } else if (1 == procedures[i]) {
                    outStr = this.coreRTL(outStr, doMirroring);
                    doMirroring = false;
                } else if (2 == procedures[i]) {
                    outStr = this.reverse(outStr, doMirroring);
                }
                ++i;
            }
            return outStr;
        }
        return txt;
    }

    private void initReorderingSchemes() {
        this.reorderingSchemes = new ArrayList<BidiScheme>();
        this.reorderingSchemes.add(new BidiScheme("VL.{3}", "VR.{3}", new int[]{3, 2}));
        this.reorderingSchemes.add(new BidiScheme("VR.{3}", "VL.{3}", new int[]{2, 3}));
        int[] nArray = new int[2];
        nArray[1] = 3;
        this.reorderingSchemes.add(new BidiScheme("IL.{3}", "VL.{3}", nArray));
        this.reorderingSchemes.add(new BidiScheme("IR.{3}", "VL.{3}", new int[]{1, 3}));
        int[] nArray2 = new int[3];
        nArray2[1] = 3;
        nArray2[2] = 2;
        this.reorderingSchemes.add(new BidiScheme("IL.{3}", "VR.{3}", nArray2));
        this.reorderingSchemes.add(new BidiScheme("IR.{3}", "VR.{3}", new int[]{1, 3, 2}));
        int[] nArray3 = new int[5];
        nArray3[1] = 3;
        nArray3[2] = 2;
        nArray3[3] = 1;
        nArray3[4] = 2;
        this.reorderingSchemes.add(new BidiScheme("IL.{3}", "IR.{3}", nArray3));
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArray4[1] = 3;
        this.reorderingSchemes.add(new BidiScheme("IR.{3}", "IL.{3}", nArray4));
        this.reorderingSchemes.add(new BidiScheme("VL.{3}", "IR.{3}", new int[]{3, 2, 1, 2}));
        this.reorderingSchemes.add(new BidiScheme("VR.{3}", "IR.{3}", new int[]{2, 3, 2, 1, 2}));
        int[] nArray5 = new int[2];
        nArray5[0] = 3;
        this.reorderingSchemes.add(new BidiScheme("VL.{3}", "IL.{3}", nArray5));
        int[] nArray6 = new int[3];
        nArray6[0] = 2;
        nArray6[1] = 3;
        this.reorderingSchemes.add(new BidiScheme("VR.{3}", "IL.{3}", nArray6));
    }

    private void initShapingSchemes() {
        this.shapingSchemes = new ArrayList<BidiScheme>();
        this.shapingSchemes.add(new BidiScheme(".{3}S.", ".{3}NN", 80));
        this.shapingSchemes.add(new BidiScheme(".{3}S.", ".{3}NH", 48));
        this.shapingSchemes.add(new BidiScheme(".{3}S.", ".L.NC", 112));
        this.shapingSchemes.add(new BidiScheme(".{3}S.", ".R.NC", 144));
        this.shapingSchemes.add(new BidiScheme(".{3}N.", ".{3}SN", 72));
        this.shapingSchemes.add(new BidiScheme(".{3}N.", ".{3}SH", 40));
        this.shapingSchemes.add(new BidiScheme(".{3}N.", ".L.SC", 104));
        this.shapingSchemes.add(new BidiScheme(".{3}N.", ".R.SC", 136));
    }

    private String reorder(String src, byte level, boolean doMirroring) {
        this.setPara(src, level, null);
        if (doMirroring) {
            return this.writeReordered(2);
        }
        return this.writeReordered(0);
    }

    private String coreLTR(String src, boolean doMirroring) {
        return this.reorder(src, (byte)0, doMirroring);
    }

    private String coreRTL(String src, boolean doMirroring) {
        return this.reorder(src, (byte)1, doMirroring);
    }

    private String reverse(String str, boolean doMirroring) {
        if (doMirroring) {
            return BidiEngine.writeReverse((String)str, (int)18);
        }
        return BidiEngine.writeReverse((String)str, (int)16);
    }

    private int getShapingOptions(String inFormat, String outFormat) {
        ListIterator<BidiScheme> it = this.shapingSchemes.listIterator();
        while (it.hasNext()) {
            BidiScheme scheme = it.next();
            if (!inFormat.matches(scheme.inFormat) || !outFormat.matches(scheme.outFormat)) continue;
            return (Integer)scheme.data;
        }
        return 0;
    }

    private String shape(String str, int options) {
        ArabicShaping shaper = new ArabicShaping(options | 4);
        try {
            return shaper.shape(str);
        }
        catch (ArabicShapingException e) {
            e.printStackTrace();
            return str;
        }
    }

    private boolean isBidi(String txt, String inFormat, String outFormat) {
        if (txt == null || txt.length() < 1) {
            return false;
        }
        if (!new Bidi(txt, 1).isLeftToRight()) {
            return true;
        }
        boolean inIsRTL = BidiConstants.TEXT_DIRECTION_RTL.equals(BidiFormat.getTextDirectionFromStr(inFormat));
        boolean outIsRTL = BidiConstants.TEXT_DIRECTION_RTL.equals(BidiFormat.getTextDirectionFromStr(outFormat));
        return inIsRTL ^ outIsRTL;
    }

    private boolean isLtr(char ch) {
        return UCharacter.getDirectionality((int)ch) == 0;
    }

    private boolean isRtl(char ch) {
        byte direction = UCharacter.getDirectionality((int)ch);
        return 1 == direction || 13 == direction;
    }

    private String normalizeFormat(String formatStr, String txt) {
        boolean isRtl;
        String direction = BidiFormat.getTextDirectionFromStr(formatStr);
        boolean isLtr = BidiConstants.TEXT_DIRECTION_CONTEXTLTR.equals(direction);
        boolean bl = isRtl = !isLtr && BidiConstants.TEXT_DIRECTION_CONTEXTRTL.equals(direction);
        if (!isLtr && !isRtl) {
            return formatStr;
        }
        int i = 0;
        int n = txt.length();
        while (i < n) {
            if (this.isLtr(txt.charAt(i))) {
                isRtl = false;
                break;
            }
            if (this.isRtl(txt.charAt(i))) {
                isRtl = true;
                break;
            }
            ++i;
        }
        char[] newFormat = formatStr.toCharArray();
        newFormat[1] = isRtl ? 82 : 76;
        return new String(newFormat);
    }

    class BidiScheme {
        String inFormat = "";
        String outFormat = "";
        Object data = null;

        BidiScheme(String inFormat, String outFormat, Object data) {
            this.inFormat = inFormat;
            this.outFormat = outFormat;
            this.data = data;
        }
    }
}

