/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.impl.DataSetImpl;
import org.eclipse.birt.chart.model.data.impl.DifferenceDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.StockDataSetImpl;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.NumberUtil;

public final class DifferenceDataSetProcessorImpl
extends DataSetAdapter {
    public final DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        boolean isBigDecimal;
        if (oResultSetDef instanceof IResultSetDataSet) {
            int n;
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
            }
            isBigDecimal = false;
            Object[][] values = new Object[(int)lRowCount][2];
            int i = 0;
            while (rsds.hasNext()) {
                Object[] o = rsds.next();
                Object[] newO = new Object[]{o[0], o[1]};
                values[i++] = newO;
                if ((isBigDecimal || !NumberUtil.isBigDecimal((Object)o[0])) && !NumberUtil.isBigDecimal((Object)o[1])) continue;
                isBigDecimal = true;
            }
            BigNumber[][] newValues = new BigNumber[values.length][2];
            i = 0;
            if (isBigDecimal) {
                Object[][] objectArray = values;
                n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] o = objectArray[n2];
                    if (o[0] instanceof Number) {
                        newValues[i][0] = NumberUtil.asBigNumber((Number)((Number)o[0]), null);
                        newValues[i++][1] = NumberUtil.asBigNumber((Number)((Number)o[1]), null);
                    } else {
                        newValues[i][0] = NumberUtil.asBigNumber((Number)Double.NaN, null);
                        newValues[i++][1] = NumberUtil.asBigNumber((Number)Double.NaN, null);
                    }
                    ++n2;
                }
                values = newValues;
            }
            i = 0;
            DifferenceEntry[] sea = new DifferenceEntry[(int)lRowCount];
            Object[][] objectArray = values;
            int n3 = values.length;
            n = 0;
            while (n < n3) {
                Object[] value;
                Object[] oTwoComponents = value = objectArray[n];
                this.validateDifferenceEntryData(oTwoComponents);
                sea[i++] = new DifferenceEntry(oTwoComponents);
                ++n;
            }
            if (ds == null) {
                ds = DifferenceDataSetImpl.create((Object)sea);
            } else {
                ds.setValues((Object)sea);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", new Object[]{ds, oResultSetDef}, Messages.getResourceBundle(this.getULocale()));
        }
        ((DataSetImpl)ds).setIsBigNumber(isBigDecimal);
        return ds;
    }

    private void validateDifferenceEntryData(Object[] obja) throws ChartException {
        boolean valid = true;
        if (obja == null) {
            valid = false;
        } else if (obja.length != 2) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.dataset.differenceseries", Messages.getResourceBundle(this.getULocale()));
        }
        if (!valid) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 30, "exception.dataset.null.differenceentry", Messages.getResourceBundle(this.getULocale()));
        }
    }

    public final Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        Number[] da = new Number[2];
        double dMin = Double.MAX_VALUE;
        Double bnMin = null;
        while (dsi.hasNext()) {
            DifferenceEntry dde = (DifferenceEntry)((Object)dsi.next());
            if (dde == null) continue;
            da[0] = dde.getPositiveValueNumber();
            da[1] = dde.getNegativeValueNumber();
            int j = 0;
            while (j < 2) {
                if (NumberUtil.isBigNumber((Object)da[j])) {
                    bnMin = bnMin == null ? (BigNumber)da[j] : bnMin.min((BigNumber)da[j]);
                } else if (dMin > da[j].doubleValue()) {
                    dMin = da[j].doubleValue();
                }
                ++j;
            }
        }
        return bnMin == null ? new Double(dMin) : bnMin;
    }

    public final Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        Number[] da = new Number[2];
        double dMax = -1.7976931348623157E308;
        Double bnMax = null;
        while (dsi.hasNext()) {
            DifferenceEntry dde = (DifferenceEntry)((Object)dsi.next());
            if (dde == null) continue;
            da[0] = dde.getPositiveValueNumber();
            da[1] = dde.getNegativeValueNumber();
            int j = 0;
            while (j < 2) {
                if (NumberUtil.isBigNumber((Object)da[j])) {
                    bnMax = bnMax == null ? (BigNumber)da[j] : bnMax.max((BigNumber)da[j]);
                } else if (dMax < da[j].doubleValue()) {
                    dMax = da[j].doubleValue();
                }
                ++j;
            }
        }
        return bnMax == null ? new Double(dMax) : bnMax;
    }

    public final DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        if (ds == null) {
            ds = StockDataSetImpl.create(null);
        }
        StringTokenizer strTokDataElement = new StringTokenizer(sDataSetRepresentation, ",");
        StringTokenizer strTokComponents = null;
        String strDataElement = null;
        String strComponent = null;
        ArrayList<DifferenceEntry> vData = new ArrayList<DifferenceEntry>();
        while (strTokDataElement.hasMoreTokens()) {
            strDataElement = strTokDataElement.nextToken().trim();
            strTokComponents = new StringTokenizer(strDataElement);
            if (strTokComponents.countTokens() == 1) {
                double dComponent = Double.parseDouble(strDataElement);
                vData.add(new DifferenceEntry(dComponent, dComponent - 2.0));
                continue;
            }
            DifferenceEntry entry = new DifferenceEntry(Double.NaN, Double.NaN);
            while (strTokComponents.hasMoreTokens()) {
                strComponent = strTokComponents.nextToken().trim().toUpperCase();
                double dComponent = Double.parseDouble(strComponent.substring(1));
                if (strComponent.startsWith("P")) {
                    entry.setPositiveValue(dComponent);
                    continue;
                }
                if (!strComponent.startsWith("N")) continue;
                entry.setNegativeValue(dComponent);
            }
            vData.add(entry);
        }
        ds.setValues(vData);
        return ds;
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.difference.sample.format", this.getULocale());
    }

    public String toString(Object[] columnData) throws ChartException {
        if (columnData == null || columnData.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < columnData.length) {
            if (columnData[i] == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
            }
            if (columnData[i] instanceof Object[]) {
                buffer.append(this.toDifferenceString((Object[])columnData[i]));
            }
            if (i < columnData.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private StringBuffer toDifferenceString(Object[] differenceArray) throws ChartException {
        if (differenceArray.length != 2 || differenceArray[0] == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "Invalid data set column");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("P" + String.valueOf(differenceArray[0]) + " ");
        buffer.append("N" + String.valueOf(differenceArray[1]));
        return buffer;
    }
}

