/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

class SearchScopeHierarchyAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeHierarchyAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_hierarchy_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_hierarchy_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IJavaSearchScope getSearchScope() {
        try {
            IMember[] members = this.fGroup.getView().getInputElements();
            if (members != null && members.length == 1) {
                IType type = members[0] instanceof IType ? (IType)members[0] : members[0].getDeclaringType();
                return SearchEngine.createHierarchyScope((IType)type);
            }
            return null;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public int getSearchScopeType() {
        return 3;
    }

    public String getFullDescription() {
        IMember[] members = this.fGroup.getView().getInputElements();
        if (members != null && members.length == 1) {
            IType type = members[0] instanceof IType ? (IType)members[0] : members[0].getDeclaringType();
            return JavaSearchScopeFactory.getInstance().getHierarchyScopeDescription(type);
        }
        return JavaSearchScopeFactory.getInstance().getWorkspaceScopeDescription(true);
    }
}

